﻿using System;
using System.Drawing;
using Sgry.Azuki.WinForms;
using Sgry.Azuki;

namespace NotepadNeue
{
    public class NotepadUtility : ICloneable
    {
        public const int WarningMarkId = 0;
        public const int ErrorMarkId = 1;
        public const int HighlightId = 2;
        public const int SearchHighlightId = 3;

        public NotepadUtility()
        {
            AllowScriptUse = true;
        }

        static NotepadUtility()
        {
            Marking.Register(new MarkingInfo(WarningMarkId, "Warning"));
            Marking.Register(new MarkingInfo(ErrorMarkId, "Error"));
            Marking.Register(new MarkingInfo(HighlightId, "Highlight"));
            Marking.Register(new MarkingInfo(SearchHighlightId, "SearchHighlight"));
        }

        public bool DrawFullWidthSpace
        {
            get;
            set;
        }
        public bool DrawSpace
        {
            get;
            set;
        }
        public bool DrawTab
        {
            get;
            set;
        }
        public bool DrawEol
        {
            get;
            set;
        }
        public bool DrawLineNumber
        {
            get;
            set;
        }
        public bool DrawEofMark
        {
            get;
            set;
        }
        public Sgry.Azuki.Antialias Antialias
        {
            get;
            set;
        }
        public bool HighlightCurrentline
        {
            get;
            set;
        }
        public bool ShowDirtBar
        {
            get;
            set;
        }
        public bool ShowHRuler
        {
            get;
            set;
        }
        public string Fontname
        {
            get;
            set;
        }
        public float Fontsize
        {
            get;
            set;
        }
        public Color Forecolor
        {
            get;
            set;
        }
        public Color Backcolor
        {
            get;
            set;
        }
        public Color Selectionfore
        {
            get;
            set;
        }
        public Color Selectionback
        {
            get;
            set;
        }
        public Color Eolcolor
        {
            get;
            set;
        }
        public Color Whitespacecolor
        {
            get;
            set;
        }
        public Color Linenumberfore
        {
            get;
            set;
        }
        public Color Linenumberback
        {
            get;
            set;
        }
        public Color Highlightcolor
        {
            get;
            set;
        }
        public Color Correspondfore
        {
            get;
            set;
        }
        public Color Correspondback
        {
            get;
            set;
        }
        public Color DirtyLineBar
        {
            get;
            set;
        }
        public Color EofColor
        {
            get;
            set;
        }
        public Color CleanedLineBar
        {
            get;
            set;
        }
        public int DisplayAssistnum
        {
            get;
            set;
        }
        public int UpdateInfomsec
        {
            get;
            set;
        }
        public bool InputAssist
        {
            get;
            set;
        }
        public bool FunctionAssist
        {
            get;
            set;
        }
        public bool AutoFormat
        {
            get;
            set;
        }
        public bool AskWhenNewlySave
        {
            get;
            set;
        }
        public bool NotExecuteProgramWhenError
        {
            get;
            set;
        }
        public bool NotExecuteProgramWhenWarning
        {
            get;
            set;
        }
        public bool AllowScriptUse
        {
            get;
            set;
        }
        public bool UseTabForIndent
        {
            get;
            set;
        }
        public int TabWidth
        {
            get;
            set;
        }
        public int BackUpNum
        {
            get;
            set;
        }
        public bool AdjustOpenEnclosure
        {
            get;
            set;
        }
        public bool AdjustCloseEnclosure
        {
            get;
            set;
        }
        public bool AutoFormatInScope
        {
            get;
            set;
        }
        public bool AskSaveTabs
        {
            get;
            set;
        }
        public bool SaveTabs
        {
            get;
            set;
        }
        public string DefaultNewLineString
        {
            get;
            set;
        }
        public bool DetectNewLineString
        {
            get;
            set;
        }
        public bool TellMixedNewLine
        {
            get;
            set;
        }
        public void SetAll(NotepadUtility nu)
        {
            nu.AutoFormat = AutoFormat;
            nu.Backcolor = Backcolor;
            nu.Correspondback = Correspondback;
            nu.Correspondfore = Correspondfore;
            nu.DisplayAssistnum = DisplayAssistnum;
            nu.DrawEol = DrawEol;
            nu.DrawEofMark = DrawEofMark;
            nu.DrawFullWidthSpace = DrawFullWidthSpace;
            nu.DrawLineNumber = DrawLineNumber;
            nu.DrawSpace = DrawSpace;
            nu.DrawTab = DrawTab;
            nu.Eolcolor = Eolcolor;
            nu.EofColor = EofColor;
            nu.CleanedLineBar = CleanedLineBar;
            nu.DirtyLineBar = DirtyLineBar;
            nu.ShowDirtBar = ShowDirtBar;
            nu.ShowHRuler = ShowHRuler;
            nu.Fontname = Fontname;
            nu.Fontsize = Fontsize;
            nu.Forecolor = Forecolor;
            nu.FunctionAssist = FunctionAssist;
            nu.Highlightcolor = Highlightcolor;
            nu.HighlightCurrentline = HighlightCurrentline;
            nu.InputAssist = InputAssist;
            nu.Linenumberback = Linenumberback;
            nu.Linenumberfore = Linenumberfore;
            nu.Selectionback = Selectionback;
            nu.Selectionfore = Selectionfore;
            nu.UpdateInfomsec = UpdateInfomsec;
            nu.Whitespacecolor = Whitespacecolor;
            nu.AskWhenNewlySave = AskWhenNewlySave;
            nu.NotExecuteProgramWhenError = NotExecuteProgramWhenError;
            nu.NotExecuteProgramWhenWarning = NotExecuteProgramWhenWarning;
            nu.TabWidth = TabWidth;
            nu.UseTabForIndent = UseTabForIndent;
            nu.Antialias = Antialias;
            nu.BackUpNum = BackUpNum;
            nu.AdjustOpenEnclosure = AdjustOpenEnclosure;
            nu.AdjustCloseEnclosure = AdjustCloseEnclosure;
            nu.AutoFormatInScope = AutoFormatInScope;
            nu.AskSaveTabs = AskSaveTabs;
            nu.SaveTabs = SaveTabs;
            nu.DetectNewLineString = DetectNewLineString;
            nu.DefaultNewLineString = DefaultNewLineString;
            nu.TellMixedNewLine = TellMixedNewLine;
        }

        public void SetToEditor(AzukiControl azukiControl)
        {
            azukiControl.HighlightsMatchedBracket = true;
            azukiControl.ColorScheme.SetMarkingDecoration(ErrorMarkId, new UnderlineTextDecoration(LineStyle.Waved, Color.Red));
            azukiControl.ColorScheme.SetMarkingDecoration(WarningMarkId, new UnderlineTextDecoration(LineStyle.Waved, Color.DarkGreen));
            azukiControl.ColorScheme.SetMarkingDecoration(HighlightId, new BgColorTextDecoration(Color.LightGray));
            azukiControl.ColorScheme.SetMarkingDecoration(SearchHighlightId, new BgColorTextDecoration(Color.LightGray));
            azukiControl.DrawsEolCode = DrawEol;
            azukiControl.DrawsFullWidthSpace = DrawFullWidthSpace;
            azukiControl.DrawsSpace = DrawSpace;
            azukiControl.DrawsTab = DrawTab;
            azukiControl.DrawsEofMark = DrawEofMark;
            azukiControl.HighlightsCurrentLine = HighlightCurrentline;
            azukiControl.ShowsLineNumber = DrawLineNumber;
            azukiControl.ShowsDirtBar = ShowDirtBar;
            azukiControl.ShowsHRuler = ShowHRuler;
            azukiControl.UsesTabForIndent = UseTabForIndent;
            azukiControl.TabWidth = TabWidth;
            azukiControl.Font = new Font(Fontname, Fontsize);
            azukiControl.ForeColor = Forecolor;
            azukiControl.BackColor = Backcolor;
            for (int i = 0; i < 255; i++)
            {
                Color f, b;
                azukiControl.ColorScheme.GetColor((Sgry.Azuki.CharClass)i, out f, out b);
                azukiControl.ColorScheme.SetColor((Sgry.Azuki.CharClass)i, f, Backcolor);
            }
            azukiControl.ColorScheme.MatchedBracketBack = Correspondback;
            azukiControl.ColorScheme.MatchedBracketFore = Correspondfore;
            azukiControl.ColorScheme.EolColor = Eolcolor;
            azukiControl.ColorScheme.HighlightColor = Highlightcolor;
            azukiControl.ColorScheme.LineNumberBack = Linenumberback;
            azukiControl.ColorScheme.LineNumberFore = Linenumberfore;
            azukiControl.ColorScheme.SelectionBack = Selectionback;
            azukiControl.ColorScheme.SelectionFore = Selectionfore;
            azukiControl.ColorScheme.WhiteSpaceColor = Whitespacecolor;
            azukiControl.ColorScheme.DirtyLineBar = DirtyLineBar;
            azukiControl.ColorScheme.EofColor = EofColor;
            azukiControl.ColorScheme.CleanedLineBar = CleanedLineBar;
            Sgry.Azuki.UserPref.Antialias = Antialias;
            azukiControl.Refresh();
        }

        public object Clone()
        {
            return MemberwiseClone();
        }
    }
}
