﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Text;

namespace NotepadNeue
{
    public class FunctionInfo : VariableInfo
    {
        List<string> contents;
        List<string[]> args;
        int shoulddisplaynum;
        AccessType acccesstype;
        public FunctionInfo()
        {
            Image = NotepadNeue.Properties.Resources.function;
            contents = new List<string>();
            args = new List<string[]>();
            shoulddisplaynum = 0;
            acccesstype = AccessType.Public;
        }
        public void AddContent(string content)
        {
            contents.Add(content);
        }
        public List<string> Content
        {
            get
            {
                return contents;
            }
            set
            {
                contents = value;
            }
        }
        public List<string[]> Argument
        {
            get
            {
                return args;
            }
            set
            {
                args = value;
            }
        }
        public void AddArgument(string[] args)
        {
            this.args.Add(args);
        }
        public string ContentAt(int index)
        {
            return contents[index];
        }
        public string[] ArgumentsAt(int index)
        {
            return args[index];
        }
        public string ArgumentFromCurrent(int index)
        {
            if (shoulddisplaynum >= args.Count) return "";
            string[] pool = args[shoulddisplaynum];
            if (index < 0 || index >= pool.Length) return "";
            return pool[index];
        }
        public string NumOfOverride
        {
            get
            {
                if (contents.Count > 1)
                {
                    return "  +" + (contents.Count - 1).ToString() + "オーバーライド";
                }
                else
                {
                    return "";
                }
            }
        }
        public int ContentCount
        {
            get
            {
                return contents.Count;
            }
        }
        public bool ifcontainsamecontent(string content)
        {
            return contents.Contains(content);
        }
        public int Displaynum
        {
            get
            {
                return shoulddisplaynum;
            }
            set
            {
                shoulddisplaynum = value;
            }
        }
        public void GainDisplayNum(int dx)
        {
            shoulddisplaynum += dx;
            if (shoulddisplaynum < 0) shoulddisplaynum = contents.Count - 1;
            if (shoulddisplaynum >= contents.Count) shoulddisplaynum = 0;
        }
        public override string HintText
        {
            get
            {
                return ContentAt(Displaynum) + NumOfOverride;
            }
            set
            {

            }
        }
    }
}
