﻿using System;
using System.Collections.Generic;
using System.Text;

namespace NotepadNeue
{
    public class ObjectInfo : AssistInformation
    {
        string name;
        public NameSpaceInfo Namespace
        {
            get;
            set;
        }
        SortedList<string, ObjectInfo> inheritedobjects;
        SortedList<string, FunctionInfo> methods;
        SortedList<string, VariableInfo> variables;
        SortedList<string, DefineValueInfo> definevalues;
        public ObjectInfo()
        {
            Image = NotepadNeue.Properties.Resources._class;
            inheritedobjects = new SortedList<string, ObjectInfo>();
            methods = new SortedList<string, FunctionInfo>();
            variables = new SortedList<string, VariableInfo>();
            definevalues = new SortedList<string, DefineValueInfo>();
        }
        public void AddInheritedObject(ObjectInfo inheritedobject, string name)
        {
            if (!inheritedobjects.ContainsKey(name))
            {
                inheritedobjects.Add(name, inheritedobject);
            }
        }
        public void AddMethod(FunctionInfo method, string name)
        {
            if (!methods.ContainsKey(name))
            {
                methods.Add(name, method);
            }
            else
            {
                FunctionInfo tempfunctioninfo = null;
                if (methods.TryGetValue(name, out tempfunctioninfo))
                {
                    tempfunctioninfo.AddContent(method.ContentAt(0));
                }
            }
        }
        public void AddVariable(VariableInfo variable, string name)
        {
            if (!variables.ContainsKey(name))
            {
                variables.Add(name, variable);
            }
        }
        public void AddDefineValueInfo(DefineValueInfo definevalue, string name)
        {
            if (!definevalues.ContainsKey(name))
            {
                definevalues.Add(name, definevalue);
            }
        }
        public virtual VariableInfo GetVariableInfo(string name)
        {
            VariableInfo ret = null;
            variables.TryGetValue(name, out ret);
            return ret;
        }
        public virtual IList<FunctionInfo> GetAllFunction()
        {
            List<FunctionInfo> ret = new List<FunctionInfo>();
            foreach (FunctionInfo fi in methods.Values)
            {
                ret.Add(fi);
            }
            foreach (ObjectInfo oi in inheritedobjects.Values)
            {
                foreach (FunctionInfo fi in oi.GetAllFunction())
                {
                    ret.Add(fi);
                }
            }
            return ret;
        }
        public virtual IList<FunctionInfo> GetAllFunction(AccessType accesstype)
        {
            List<FunctionInfo> ret = new List<FunctionInfo>();
            foreach (FunctionInfo fi in methods.Values)
            {
                if (fi.AccessType >= accesstype) ret.Add(fi);
            }
            foreach (ObjectInfo oi in inheritedobjects.Values)
            {
                foreach (FunctionInfo fi in oi.GetAllFunction(AccessType.Protected))
                {
                    if (fi.AccessType >= accesstype) ret.Add(fi);
                }
            }
            return ret;
        }
        public virtual IList<VariableInfo> GetAllVariable()
        {
            List<VariableInfo> ret = new List<VariableInfo>();
            foreach (VariableInfo vi in variables.Values)
            {
                ret.Add(vi);
            }
            foreach (ObjectInfo oi in inheritedobjects.Values)
            {
                foreach (VariableInfo vi in oi.GetAllVariable())
                {
                    ret.Add(vi);
                }
            }
            return ret;
        }
        public virtual IList<VariableInfo> GetAllVariable(AccessType accesstype)
        {
            List<VariableInfo> ret = new List<VariableInfo>();
            foreach (VariableInfo vi in variables.Values)
            {
                if (vi.AccessType >= accesstype) ret.Add(vi);
            }
            foreach (ObjectInfo oi in inheritedobjects.Values)
            {
                foreach (VariableInfo vi in oi.GetAllVariable(AccessType.Protected))
                {
                    if (vi.AccessType >= accesstype) ret.Add(vi);
                }
            }
            return ret;
        }
        public virtual IList<DefineValueInfo> GetAllDefineValue()
        {
            return definevalues.Values;
        }
        public BasicTree UserObjectTree
        {
            get;
            set;
        }
        public virtual string Name
        {
            get
            {
                return name;
            }
            set
            {
                name = value;
            }
        }
        public ObjectInfo Clone()
        {
            ObjectInfo ret = new ObjectInfo();
            foreach (ObjectInfo oi in inheritedobjects.Values)
            {
                ret.AddInheritedObject(oi, oi.name);
            }
            foreach (FunctionInfo fi in methods.Values)
            {
                ret.AddMethod(fi, fi.Name);
            }
            foreach (VariableInfo vi in variables.Values)
            {
                ret.AddVariable(vi, vi.Name);
            }
            ret.Namespace = Namespace;
            ret.UserObjectTree = UserObjectTree;
            return ret;
        }
        public override string Text
        {
            get
            {
                return name;
            }
            set
            {
                name = value;
            }
        }
        public override string HintText
        {
            get
            {
                return "";
            }
            set
            {

            }
        }
    }
}
