﻿using System;
using System.Collections.Generic;
using System.Text;

using System.Drawing;

using SlimDX;
using SlimDX.Direct3D9;

using System.Runtime.InteropServices;

namespace testgame
{

    class DxChar
    {
        float x;
        float y;
        float z;

        bool disposed;
        Color4 color;
        int width;
        int height;
        char c;
        Texture t;

        Device device;

        byte[] writedata = new byte[] { (byte)255, (byte)255, (byte)255, (byte)0 };

        int fontsize;
        public DxChar(char c, float x, float y, float z, int height, int width, string facename, Color4 color, Device device)
        {
            this.x = x;
            this.y = y;
            this.z = z;
            this.c = c;
            this.color = color;
            this.fontsize = height;
            this.device = device;
            CreateTexture(c, facename, height);
        }
        private void CreateTexture(uint c, string facename, int height)
        {
            System.Drawing.Font font = new System.Drawing.Font(facename, height);

            WinAPI.GLYPHMETRICS metrics = new WinAPI.GLYPHMETRICS();
            WinAPI.TEXTMETRIC tmetrics = new WinAPI.TEXTMETRIC();
            WinAPI.MAT2 matrix = new WinAPI.MAT2();
            matrix.eM11.value = 1;
            matrix.eM12.value = 0;
            matrix.eM21.value = 0;
            matrix.eM22.value = 1;
            using (Graphics g = Graphics.FromHwnd(IntPtr.Zero))
            {
                IntPtr hdc = g.GetHdc();
                IntPtr prev = WinAPI.SelectObject(hdc, font.ToHfont());
                int bufferSize = (int)WinAPI.GetGlyphOutlineW(hdc, c, (uint)6, out metrics, 0, IntPtr.Zero, ref matrix);
                IntPtr buffer = Marshal.AllocHGlobal(bufferSize);
                try
                {
                    uint ret;
                    if ((ret = WinAPI.GetGlyphOutlineW(hdc, c, (uint)6, out metrics, (uint)bufferSize, buffer, ref matrix)) > 0 && WinAPI.GetTextMetrics(hdc, ref tmetrics))
                    {
                        int iBmp_w = metrics.gmBlackBoxX + (4 - (metrics.gmBlackBoxX % 4)) % 4;
                        int iBmp_h = metrics.gmBlackBoxY;
                        int iOfs_x = metrics.gmptGlyphOrigin.x, iOfs_y = tmetrics.ascent - metrics.gmptGlyphOrigin.y;
                        this.width = metrics.gmCellIncX;
                        this.height = tmetrics.height;
                        t = new Texture(device, this.width, this.height, 0, Usage.None, Format.A8R8G8B8, Pool.Managed);
                        DataRectangle rec = t.LockRectangle(0, LockFlags.Discard);
                        byte[] data = new byte[bufferSize];
                        Marshal.Copy(buffer, data, 0, bufferSize);
                        int offset1 = (iOfs_x + iOfs_y * this.width) * 4;
                        int offset2 = (iOfs_x + this.width - iOfs_x - iBmp_w) * 4;
                        WinAPI.ZeroMemory(rec.Data.DataPointer, (uint)rec.Data.Length);
                        for (int i = iOfs_y; i < iOfs_y + iBmp_h; i++)
                        {
                            for (int j = iOfs_x; j < iOfs_x + iBmp_w; j++)
                            {
                                writedata[3] = (byte)((255 * data[j - iOfs_x + iBmp_w * (i - iOfs_y)]) / 64);
                                if (j == iOfs_x)
                                {
                                    if (i == iOfs_y)
                                    {
                                        rec.Data.Seek(offset1, System.IO.SeekOrigin.Current);
                                    }
                                    else
                                    {
                                        rec.Data.Seek(offset2, System.IO.SeekOrigin.Current);
                                    }
                                }
                                rec.Data.Write(writedata, 0, writedata.Length);
                            }
                        }
                        t.UnlockRectangle(0);
                    }
                }
                finally
                {
                    WinAPI.SelectObject(hdc, prev);
                    WinAPI.DeleteObject(prev);
                    g.ReleaseHdc(hdc);
                    Marshal.FreeHGlobal(buffer);
                }
            }
            font.Dispose();
        }
        public void ChangeText(char c, string facename, int height)
        {
            this.fontsize = height;
            if (t != null)
            {
                t.Dispose();
                t = null;
            }
            CreateTexture(c, facename, height);
        }
        public void Update()
        {
        }
        public void Draw()
        {

            TransformedColoredTexturedVertex[] tctvs = new TransformedColoredTexturedVertex[]{
               new TransformedColoredTexturedVertex(new Vector4(x,y,z,1.0f),color.ToArgb(),new Vector2(0,0)),
               new TransformedColoredTexturedVertex(new Vector4(x+width,y,z,1.0f),color.ToArgb(),new Vector2(1,0)),
               new TransformedColoredTexturedVertex(new Vector4(x,y+height,z,1.0f),color.ToArgb(),new Vector2(0,1)),
               new TransformedColoredTexturedVertex(new Vector4(x+width,y+height,z,1.0f),color.ToArgb(),new Vector2(1,1))
           };
            if (border != null)
            {
                for (int i = 0; i < tctvs.Length; i++)
                {
                    tctvs[i].Color = border.color.ToArgb();
                }
                for (int i = 0; i < tctvs.Length; i++)
                {
                    Matrix m = Matrix.Identity;
                    switch (i)
                    {
                        case 0:
                            for (int j = 0; j < tctvs.Length; j++)
                            {
                                //11
                                tctvs[j].Position = new Vector4(tctvs[j].Position.X + border.thickness, tctvs[j].Position.Y + border.thickness, tctvs[j].Position.Z, tctvs[j].Position.W);
                            }
                            break;
                        case 1:
                            for (int j = 0; j < tctvs.Length; j++)
                            {
                                //1-1
                                tctvs[j].Position = new Vector4(tctvs[j].Position.X, tctvs[j].Position.Y - 2 * border.thickness, tctvs[j].Position.Z, tctvs[j].Position.W);
                            }
                            break;
                        case 2:
                            for (int j = 0; j < tctvs.Length; j++)
                            {
                                //-1-1
                                tctvs[j].Position = new Vector4(tctvs[j].Position.X - 2 * border.thickness, tctvs[j].Position.Y, tctvs[j].Position.Z, tctvs[j].Position.W);
                            }
                            break;
                        case 3:
                            for (int j = 0; j < tctvs.Length; j++)
                            {
                                //-11
                                tctvs[j].Position = new Vector4(tctvs[j].Position.X, tctvs[j].Position.Y + 2 * border.thickness, tctvs[j].Position.Z, tctvs[j].Position.W);
                            }
                            break;
                    }
                    device.VertexFormat = TransformedColoredTexturedVertex.Format;
                    device.SetTexture(0, t);
                    device.DrawUserPrimitives(PrimitiveType.TriangleStrip, 2, tctvs);
                }

                for (int i = 0; i < tctvs.Length; i++)
                {
                    tctvs[i].Color = color.ToArgb();
                    tctvs[i].Position = new Vector4(tctvs[i].Position.X + border.thickness, tctvs[i].Position.Y - border.thickness, tctvs[i].Position.Z, tctvs[i].Position.W);
                }
            }
            device.VertexFormat = TransformedColoredTexturedVertex.Format;
            device.SetTexture(0, t);
            device.DrawUserPrimitives(PrimitiveType.TriangleStrip, 2, tctvs);

        }
        public void Dispose()
        {
            Dispose(true);
            GC.SuppressFinalize(this);
        }
        private void Dispose(bool disposing)
        {
            if (!this.disposed)
            {
                if (disposing)
                {
                    if (t != null)
                    {
                        t.Dispose();
                        t = null;
                    }
                }
            }
            disposed = true;
        }
        public Border border
        {
            get;
            set;
        }
    }
}
