﻿using System;
using System.IO;
using System.Windows.Forms;
using System.Collections.Generic;
using System.Collections;
using System.Text;
using System.Drawing;
using SlimDX;
using SlimDX.Direct3D9;
using SlimDX.DirectInput;
using DirectShowLib;
using System.Runtime.InteropServices;

namespace testgame
{
    class MyGame : Game
    {
        enum MovieState
        {
            notinitialized = 0,
            running = 1,
            pause = 2
        }


        [Flags]
        enum MessageCue
        {
            none = 0,
            changemovie = 1,
            changebackground = 2,
            releasemovie = 4,
            playmovie = 8
        }

        MessageCue messagecue = MessageCue.none;

        MovieState mstate = MovieState.notinitialized;

        NormalDxString st;
        NormalDxString caretst;
        Sprite sprite;
        Movie m;
        string fontname = "";
        int fontsize = 20;
        Bitmap bit;
        int bitwidth;
        int bitheight;
        Point caretpos = new Point(0, 0);
        int caretcount = 0;
        double movietime;
        string[] filenames = new string[1] { "" };
        int filenum = 0;
        string[] content;
        Vector2[] contentpos;
        bool[][] InSelection;
        Color4[][] cols;
        int startlinenum;
        Texture overray;
        Texture border;
        Texture background;
        public float overrayalpha = 0.8f;
        private bool fixaspect = false;
        int headerwidth = 0;
        public MyGame()
        {
            /*//ウィンドウの初期設定
            this.Window.ClientSize = new Size(width, height);
            this.Window.Text = "PPD";
            this.Window.MaximizeBox = false;
            this.Window.MinimizeBox = false;

            //Cursor.Hide();
            this.Window.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedSingle;
            //終了イベント追加
            //this.Exiting += new EventHandler(this.exito);
            this.Window.FormClosing += new FormClosingEventHandler(this.exito);*/
        }
        protected override void Initialize()
        {
            base.Initialize();
        }
        protected override void LoadContent()
        {
            if (device == null) return;
            initdevicesetting();
            //Spriteの生成(D3Dデバイスの生成の後ではできないみたい)
            this.sprite = new Sprite(this.device);
            st = new NormalDxString("", 0, 0, 0.5f, fontsize, 0, FontWeight.Normal, exac.Font.Name, new Color4(1, 1, 1, 1), device, sprite);
            caretst = new NormalDxString("|", 0, 0, 0.5f, fontsize, 0, FontWeight.Normal, exac.Font.Name, new Color4(1, 1, 1, 1), device, sprite);

            overray = new Texture(device, 1, 1, 0, Usage.None, Format.A8R8G8B8, Pool.Managed);
            DataRectangle rec = overray.LockRectangle(0, LockFlags.Discard);
            rec.Data.WriteByte((byte)(0));
            rec.Data.WriteByte((byte)(0));
            rec.Data.WriteByte((byte)(0));
            rec.Data.WriteByte((byte)(255));
            overray.UnlockRectangle(0);
            border = new Texture(device, 1, 1, 0, Usage.None, Format.A8R8G8B8, Pool.Managed);
            rec = border.LockRectangle(0, LockFlags.Discard);
            rec.Data.WriteByte((byte)(255));
            rec.Data.WriteByte((byte)(255));
            rec.Data.WriteByte((byte)(255));
            rec.Data.WriteByte((byte)(255));
            border.UnlockRectangle(0);
            if ((messagecue & MessageCue.changebackground) == MessageCue.changebackground && bit != null)
            {
                try
                {
                    bitwidth = bit.Width;
                    bitheight = bit.Height;
                    background = new Texture(device, bit.Width, bit.Height, 0, Usage.None, Format.A8R8G8B8, Pool.Managed);
                    rec = background.LockRectangle(0, LockFlags.Discard);
                    System.Drawing.Imaging.BitmapData data = bit.LockBits(new Rectangle(0, 0, bit.Width, bit.Height), System.Drawing.Imaging.ImageLockMode.ReadOnly, System.Drawing.Imaging.PixelFormat.Format32bppArgb);
                    IntPtr src = data.Scan0;
                    rec.Data.WriteRange(src, data.Stride * data.Height);
                    bit.UnlockBits(data);
                    background.UnlockRectangle(0);
                }
                catch
                {
                }
                messagecue &= ~MessageCue.changebackground;
            }
            //for easy
            /*if (changebackgroundflag)
            {
                CreateBackGround();
                changebackgroundflag = false;
            }*/
            //
            content = new string[0];
            contentpos = new Vector2[0];
            if (m != null)
            {
                if (m.initialized)
                {
                    movietime = m.GetTime();
                    filenames[filenum] = m.filename;
                    m.Pause();
                    m.Dispose();
                    m = null;
                }
                m = new Movie(filenames[filenum], 0, 0, 0.5f, device, sprite, util);
                m.Finished += new EventHandler(m_Finished);
                m.fixaspect = fixaspect;
                if (mstate == MovieState.running)
                {
                    m.filename = filenames[filenum];
                    m.initialize();
                    if (m.initialized)
                    {
                        m.displaywidth = width;
                        m.displayheight = height;
                        m.Seek(movietime);
                        m.Play();
                    }
                    else
                    {
                        mstate = MovieState.notinitialized;
                    }
                }
            }
            else
            {
                m = new Movie(filenames[filenum], 0, 0, 0.5f, device, sprite, util);
                m.Finished += new EventHandler(m_Finished);
            }
            base.LoadContent();
        }
        public void ChangeFont(string fontname, int fontsize)
        {
            this.fontname = fontname;
            this.fontsize = fontsize;
        }
        private void initdevicesetting()
        {
            device.SetRenderState(RenderState.ZEnable, true);
            device.SetRenderState(RenderState.AlphaBlendEnable, true);
            device.SetRenderState(RenderState.SourceBlend, Blend.SourceAlpha);
            device.SetRenderState(RenderState.DestinationBlend, Blend.InverseSourceAlpha);
            device.SetRenderState(RenderState.BlendOperation, BlendOperation.Add);
            if (device.Capabilities.TextureOperationCaps == TextureOperationCaps.Modulate)
            {
                device.SetTextureStageState(0, TextureStage.AlphaOperation, TextureOperation.Modulate);
                device.SetTextureStageState(0, TextureStage.AlphaArg1, TextureArgument.Texture);
                device.SetTextureStageState(0, TextureStage.AlphaArg2, TextureArgument.Current);
            }
            if (device.Capabilities.TextureFilterCaps == FilterCaps.MagLinear)
            {
                device.SetSamplerState(0, SamplerState.MagFilter, TextureFilter.Linear);
            }
            if (device.Capabilities.TextureFilterCaps == FilterCaps.MinLinear)
            {
                device.SetSamplerState(0, SamplerState.MinFilter, TextureFilter.Linear);
            }
            if (device.Capabilities.TextureFilterCaps == FilterCaps.MipLinear)
            {
                device.SetSamplerState(0, SamplerState.MipFilter, TextureFilter.Linear);
            }
        }
        public bool FixAspect
        {
            get
            {
                return fixaspect;
            }
            set
            {
                fixaspect = value;
                if (m != null)
                {
                    m.fixaspect = value;
                }
            }
        }
        public bool OpenMovie(string[] st)
        {
            m.filename = st[0];
            filenames = st;
            messagecue |= MessageCue.changemovie;
            return true;
        }
        public bool ReleaseMovie()
        {
            messagecue |= MessageCue.releasemovie;
            return true;
        }
        public bool ChangeBackGround(Bitmap bit)
        {
            this.bit = bit;
            messagecue |= MessageCue.changebackground;
            return true;
        }
        public void Play()
        {
            messagecue |= MessageCue.playmovie;
        }
        public override void OnLostDevice()
        {
            base.OnLostDevice();
            sprite.OnLostDevice();
        }
        public override void OnResetDevice()
        {
            base.OnResetDevice();
            sprite.OnResetDevice();
        }
        protected override void UnloadContent()
        {
            base.UnloadContent();
        }
        protected override void Dispose(bool disposing)
        {
            if (sprite != null)
            {
                sprite.Dispose();
                sprite = null;
            }
            if (m != null && m.initialized)
            {
                m.Pause();
                m.Dispose();
                m = null;
            }
            if (st != null)
            {
                st.Dispose();
                st = null;
            }
            if (caretst != null)
            {
                caretst.Dispose();
                caretst = null;
            }
            if (overray != null)
            {
                overray.Dispose();
                overray = null;
            }
            if (border != null)
            {
                border.Dispose();
                border = null;
            }
            if (background != null)
            {
                background.Dispose();
                background = null;
            }
            base.Dispose(disposing);
        }
        public override void ReCreate()
        {
            base.ReCreate();
            if (m != null)
            {
                m.displaywidth = width;
                m.displayheight = height;
            }
        }
        protected override void Update()
        {
            if (device == null || sprite == null) return;
            if (fontname != "")
            {
                headerwidth = 0;
                st.changefont(fontsize, 0, FontWeight.Normal, fontname, new Color4(1, 1, 1, 1));
                caretst.changefont(fontsize, 0, FontWeight.Normal, fontname, new Color4(1, 1, 1, 1));
                fontname = "";
            }
            if ((messagecue & MessageCue.changemovie) == MessageCue.changemovie)
            {
                if (m.initialized)
                {
                    m.Dispose();
                    m = null;
                    m = new Movie(filenames[filenum], 0, 0, 0.5f, device, sprite, util);
                    m.Finished += new EventHandler(m_Finished);
                    m.fixaspect = fixaspect;
                }
                m.initialize();
                m.displaywidth = width;
                m.displayheight = height;
                if (m.initialized)
                {
                    mstate = MovieState.pause;
                }
                messagecue &= ~MessageCue.changemovie;
            }
            if ((messagecue & MessageCue.releasemovie) == MessageCue.releasemovie)
            {
                if (m.initialized)
                {
                    m.Dispose();
                    m = null;
                    m = new Movie(filenames[filenum], 0, 0, 0.5f, device, sprite, util);
                    m.Finished += new EventHandler(m_Finished);
                    m.fixaspect = fixaspect;
                }
                mstate = MovieState.notinitialized;
                messagecue &= ~MessageCue.releasemovie;
            }
            if ((messagecue & MessageCue.playmovie) == MessageCue.playmovie)
            {
                if (m.initialized)
                {
                    m.Pause();
                    m.Seek(0);
                    m.Play();
                    mstate = MovieState.running;
                }
                messagecue &= ~MessageCue.playmovie;
            }
            try
            {
                UpdateText();
                /*st.Text = (exac.LineCount < 10000 ? (1000).ToString() : exac.LineCount.ToString());
                st.position = new Vector2(st.width, 0);
                st.Text = exac.Text;*/
                int a = 0, b = 0;
                exac.GetSelection(out a, out b);
                Point p = exac.GetPositionFromIndex(b);
                int head = exac.GetLineHeadIndexFromCharIndex(b);
                string headtocaret = exac.GetTextInRange(head, b);
                headtocaret = headtocaret.Replace("\t", createspace(exac.TabWidth));
                caretst.position = new Vector2(caretst.MeasureWidth(headtocaret) + contentpos[0].X - caretst.width / 2, p.Y);
            }
            catch { }
            //caretst.position = new Vector2(p.X - 3, p.Y);
            caretcount++;
            if (caretcount > 60)
            {
                caretcount = 0;
            }
        }

        void m_Finished(object sender, EventArgs e)
        {
            if (filenum == filenames.Length - 1)
            {
                filenum = 0;
            }
            else
            {
                filenum++;
            }
            messagecue |= MessageCue.changemovie;
            messagecue |= MessageCue.playmovie;
        }
        private void UpdateText()
        {
            headerwidth = exac.View.LineNumAreaWidth;
            int start = exac.GetIndexFromPosition(new Point(0, 0));
            int startline = 0, startcolumn = 0;
            int begin, end;
            exac.GetLineColumnIndexFromCharIndex(start, out startline, out startcolumn);
            exac.GetSelection(out begin, out end);
            startlinenum = startline;
            int count = 0;
            ArrayList lineheads = new ArrayList();
            while (true)
            {
                try
                {
                    int linehead = exac.GetLineHeadIndex(startline + count);
                    lineheads.Add(linehead);
                    count++;
                }
                catch (ArgumentOutOfRangeException aoore)
                {
                    break;
                }
            }
            content = new string[count];
            contentpos = new Vector2[count];
            InSelection = new bool[count][];
            cols = new Color4[count][];
            /*for (int i = 0; i < content.Length; i++)
            {
                content[i] = "";
                contentpos[i] = new Vector2(0, 0);
            }*/
            for (int i = 0; i < count; i++)
            {
                if (i == count - 1)
                {
                    if (exac.TextLength == 0)
                    {
                        content[i] = "";
                    }
                    else
                    {
                        content[i] = exac.GetTextInRange((int)lineheads[i], exac.TextLength);
                    }
                }
                else
                {
                    content[i] = exac.GetTextInRange((int)lineheads[i], (int)lineheads[i + 1]);
                }

                Point p = exac.GetPositionFromIndex((int)lineheads[i]);
                contentpos[i] = new Vector2(p.X, p.Y);
                content[i] = content[i].Replace("\t", createspace(exac.TabWidth));

                cols[i] = new Color4[content[i].Length];
                InSelection[i] = new bool[content[i].Length];
                for (int j = 0; j < cols[i].Length; j++)
                {
                    Sgry.Azuki.CharClass cc = exac.Document.GetCharClass((int)lineheads[i] + j);
                    Color f, b;
                    exac.ColorScheme.GetColor(cc, out f, out b);
                    if (cc < (Sgry.Azuki.CharClass)100)
                    {
                        cols[i][j] = new Color4(Color.White);
                    }
                    else
                    {
                        cols[i][j] = new Color4(f);
                    }
                    if (begin <= (int)lineheads[i] + j && (int)lineheads[i] + j < end)
                    {
                        InSelection[i][j] = true;
                    }
                }
                if (p.Y >= this.height) break;
            }
        }
        private string createspace(int num)
        {
            StringBuilder sb = new StringBuilder();
            while (sb.Length < num)
            {
                sb.Append(" ");
            }
            return sb.ToString();
        }
        protected override void Draw()
        {
            if (device == null || sprite == null) return;
            this.device.Clear(ClearFlags.Target | ClearFlags.ZBuffer, Color.Black, 1.0f, 0);
            this.device.BeginScene();
            this.sprite.Begin(SpriteFlags.AlphaBlend);
            try
            {
                if (background != null)
                {
                    RegularDrawRect(new RectangleF(0, 0, bitwidth, bitheight), new Color4(1, 1, 1, 1), background);
                }
                if (m != null && m.initialized)
                {
                    m.anotherDraw();
                }
                DrawRect(new Rectangle(0, 0, width, height), new Color4(overrayalpha, 1, 1, 1), overray);
                //Surface suf = device.GetRenderTarget(0);
                int spacewidth = 0;
                st.Text = " 0";
                spacewidth = st.width;
                st.Text = "0";
                spacewidth -= st.width;
                for (int i = 0; i < content.Length; i++)
                {
                    if (content[i] == null) break;
                    /*st.Text = content[i];*/
                    st.position = contentpos[i];
                    for (int j = 0; j < content[i].Length; j++)
                    {
                        if (InSelection[i][j])
                        {
                            st.Color = new Color4(Color.Gray);
                        }
                        else
                        {
                            st.Color = cols[i][j];
                        }
                        st.Text = content[i][j].ToString();
                        if (st.Text == " ")
                        {
                            st.position = new Vector2(st.position.X + spacewidth, st.position.Y);
                        }
                        else
                        {
                            st.Draw();
                            st.position = new Vector2(st.position.X + st.width, st.position.Y);
                        }
                    }
                    /*if (cols[i].Length > 0)
                    {
                        st.Color = cols[i][0];
                    }
                    else
                    {
                        st.Color = new Color4(Color.White);
                    }
                    st.Draw();*/
                }
                st.Color = new Color4(Color.White);
                if (caretcount < 30)
                {
                    caretst.Draw();
                }
                this.sprite.End();
                this.device.Clear(ClearFlags.Target | ClearFlags.ZBuffer, Color.Black, 1.0f, 0, new Rectangle[] { new Rectangle(0, 0, headerwidth + 5, height) });
                this.sprite.Begin(SpriteFlags.AlphaBlend);
                if (background != null)
                {
                    RegularDrawRect(new RectangleF(0, 0, bitwidth, bitheight), new Color4(1, 1, 1, 1), background);
                }
                if (m != null && m.initialized)
                {
                    m.anotherDraw();
                }
                DrawRect(new Rectangle(0, 0, width, height), new Color4(overrayalpha, 1, 1, 1), overray);
                for (int i = 0; i < content.Length; i++)
                {
                    if (content[i] == null) break;
                    st.Text = (startlinenum + i + 1).ToString();
                    int ewidth = st.width / st.Text.Length;
                    st.position = new Vector2(headerwidth - st.width, contentpos[i].Y);
                    st.Draw();
                }
                DrawRect(new RectangleF(headerwidth, 0, 1, this.height), new Color4(1, 1, 1, 1), border);
                base.Draw();
            }
            catch(Exception ex)
            {
                MessageBox.Show(ex.StackTrace);
            }
            finally
            {
                Result r = this.sprite.End();
                this.device.EndScene();
            }
        }
        private void DrawRect(RectangleF rec, Color4 color, Texture t)
        {

            TransformedColoredTexturedVertex[] tcvs = new TransformedColoredTexturedVertex[]{
                new TransformedColoredTexturedVertex(new Vector4(rec.X,rec.Y,0.5f,1.0f),color.ToArgb(),new Vector2(0,0)),
                new TransformedColoredTexturedVertex(new Vector4(rec.X+rec.Width,rec.Y,0.5f,1.0f),color.ToArgb(),new Vector2(0,0)),
                new TransformedColoredTexturedVertex(new Vector4(rec.X,rec.Y+rec.Height,0.5f,1.0f),color.ToArgb(),new Vector2(0,0)),
                new TransformedColoredTexturedVertex(new Vector4(rec.X+rec.Width,rec.Y+rec.Height,0.5f,1.0f),color.ToArgb(),new Vector2(0,0))
            };
            device.VertexFormat = TransformedColoredTexturedVertex.Format;
            device.SetTexture(0, t);
            device.DrawUserPrimitives(PrimitiveType.TriangleStrip, 2, tcvs);
        }
        private void RegularDrawRect(RectangleF rec, Color4 color, Texture t)
        {

            TransformedColoredTexturedVertex[] tcvs = new TransformedColoredTexturedVertex[]{
                new TransformedColoredTexturedVertex(new Vector4(rec.X,rec.Y,0.5f,1.0f),color.ToArgb(),new Vector2(0,0)),
                new TransformedColoredTexturedVertex(new Vector4(rec.X+rec.Width,rec.Y,0.5f,1.0f),color.ToArgb(),new Vector2(1,0)),
                new TransformedColoredTexturedVertex(new Vector4(rec.X,rec.Y+rec.Height,0.5f,1.0f),color.ToArgb(),new Vector2(0,1)),
                new TransformedColoredTexturedVertex(new Vector4(rec.X+rec.Width,rec.Y+rec.Height,0.5f,1.0f),color.ToArgb(),new Vector2(1,1))
            };
            device.VertexFormat = TransformedColoredTexturedVertex.Format;
            device.SetTexture(0, t);
            device.DrawUserPrimitives(PrimitiveType.TriangleStrip, 2, tcvs);
        }
    }
}