﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Drawing;
using System.Windows.Forms;
using System.Runtime.InteropServices;

using Debug = System.Diagnostics.Debug;

namespace testgame
{
    public static class WinAPI
    {
        [StructLayout(LayoutKind.Sequential)]
        public struct FIXED
        {
            public short fract;
            public short value;
        }

        [StructLayout(LayoutKind.Sequential)]
        public struct MAT2
        {
            [MarshalAs(UnmanagedType.Struct)]
            public FIXED eM11;
            [MarshalAs(UnmanagedType.Struct)]
            public FIXED eM12;
            [MarshalAs(UnmanagedType.Struct)]
            public FIXED eM21;
            [MarshalAs(UnmanagedType.Struct)]
            public FIXED eM22;
        }

        [StructLayout(LayoutKind.Sequential)]
        public struct POINT
        {
            public int x;
            public int y;
        }

        [StructLayout(LayoutKind.Sequential)]
        public struct POINTFX
        {
            [MarshalAs(UnmanagedType.Struct)]
            public FIXED x;
            [MarshalAs(UnmanagedType.Struct)]
            public FIXED y;
        }

        [StructLayout(LayoutKind.Sequential)]
        public struct GLYPHMETRICS
        {
            public int gmBlackBoxX;
            public int gmBlackBoxY;
            [MarshalAs(UnmanagedType.Struct)]
            public POINT gmptGlyphOrigin;
            public short gmCellIncX;
            public short gmCellIncY;
        }

        [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Unicode)]
        public struct TEXTMETRIC
        {
            public Int32 height;
            public Int32 ascent;
            public Int32 descent;
            public Int32 internalLeading;
            public Int32 externalLeading;
            public Int32 aveCharWidth;
            public Int32 maxCharWidth;
            public Int32 weight;
            public Int32 overhang;
            public Int32 digitizedAspectX;
            public Int32 digitizedAspectY;
            public char firstChar;
            public char lastChar;
            public char defaultChar;
            public char breakChar;
            public byte italic;
            public byte underlined;
            public byte struckOut;
            public byte pitchAndFamily;
            public byte charSet;
        }

        [DllImport("user32.dll")]
        public static extern IntPtr GetDC(IntPtr hWnd);

        [DllImport("gdi32.dll")]
        public static extern IntPtr SelectObject(IntPtr hdc, IntPtr gdiObj);

        [DllImport("gdi32.dll")]
        public static extern uint GetGlyphOutlineW(IntPtr hdc, uint uChar, uint uFormat, out GLYPHMETRICS lpgm, uint cbBuffer, IntPtr lpvBuffer, ref MAT2 lpmat2);

        [DllImport("gdi32.dll")]
        public static extern bool GetTextMetrics(IntPtr hdc, ref TEXTMETRIC lptm);

        [DllImport("kernel32.dll")]
        public static extern void FillMemory(IntPtr ptr, uint size, byte fill);

        [DllImport("kernel32.dll")]
        public static extern void ZeroMemory(IntPtr ptr, uint size);

        [DllImport("gdi32.dll")]
        public static extern int DeleteObject(IntPtr gdiObj);

    }
}
