﻿<?xml version="1.0" encoding="utf-8"?>
<root>
	<function name = "strcpy" type = "char*" content = "char *strcpy(char *s, const char *t)">
	   <summary text="文字配列に文字列をコピーします。引数の文字配列をそのまま返します。文字列の代入に使用します。"/>
	   <argument text="コピー先文字配列"/>
	   <argument text="コピー元文字配列"/>
	</function>
	<function name="strncpy" type="char*" content="char *strncpy(char *s, const char *t, size_t n)">
	   <summary text="文字配列に指定文字数だけ文字列をコピーします。引数の文字配列をそのまま返します。文字数が多い場合にはナル文字を付加しないので、必ず、s[n] = '\0'; としてNULL文字を付加して下さい。"/>
	   <argument text="コピー先文字配列"/>
	   <argument text="コピー元文字配列"/>
	   <argument text="最大コピー文字数"/>
	</function>
	<function name="strcat" type="char*" content="char *strcat(char *s, const char *t)">
	   <summary text="文字配列の後ろに文字列をつなげます。引数の文字配列をそのまま返します。"/>
	   <argument text="コピー先文字配列"/>
	   <argument text="コピー元文字配列"/>
	</function>
	<function name="strncat" type="char*" content="char *strncat(char *s, const char *t, size_t n)">
	   <summary text="文字配列の後ろに指定文字数だけ文字列をつなげます。引数の文字配列をそのまま返します。"/>
	   <argument text="コピー先文字配列"/>
	   <argument text="コピー元文字配列"/>
	   <argument text="最大連結文字数"/>
	</function>
	<function name="strlen" type="size_t" content="size_t strlen(const char *s)">
	   <summary text="文字列の長さを返します。NULL文字は含みません。"/>
	   <argument text="文字列"/>
	</function>
	<function name="strcmp" type="int" content="int strcmp(const char *s, const char *t)">
	   <summary text="文字列1と文字列2を比較します。文字列1が大きいときは正、同じ時は0、文字列2が大きいときは負を返します"/>
	   <argument text="文字列1"/>
	   <argument text="文字列2"/>
	</function>
	<function name="strncmp" type="int" content="int strncmp(const char *s, const char *t, size_t n)">
	   <summary text="文字列を指定文字数だけ比較します。文字列1が大きいときは正、同じ時は0、文字列2が大きいときは負を返します。"/>
	   <argument text="文字列1"/>
	   <argument text="文字列2"/>
	   <argument text="比較文字数"/>
	</function>
	<function name="strchr" type="char*" content="char *strchr(const char *s, int c)">
	   <summary text="文字列の先頭から文字を検索します。見つからない場合はNULLを返します。"/>
	   <argument text="検索対象文字列"/>
	   <argument text="検索する文字"/>
	</function>
	<function name="strrchr" type="char*" content="char *strrchr(const char *s, int c)">
	   <summary text="文字列の後ろから文字を検索します。見つからない場合はNULLを返します。"/>
	   <argument text="検索対象文字列"/>
	   <argument text="検索する文字"/>
	</function>
	<function name="strcspn" type="size_t" content="size_t strcspn(const char *s, const char *t)">
	   <summary text="対象文字列の中から検索文字列に含まれる文字を検索します。見つかった位置までの文字数を返します。"/>
	   <argument text="検索対象文字列"/>
	   <argument text="検索する文字列"/>
	</function>
	<function name="strspn" type="size_t" content="size_t strcspn(const char *s, const char *t)">
	   <summary text="対象文字列の中から検索文字列に含まれない文字を検索します。見つからない位置までの文字数を返します。"/>
	   <argument text="検索対象文字列"/>
	   <argument text="検索する文字列"/>
	</function>
	<function name="strpbrk" type="char*" content="char *strpbrk(const char *s, const char *t)">
	   <summary text="対象文字列の先頭から検索文字列に含まれる文字を検索します。見つからない場合はNULLを返します。"/>
	   <argument text="検索対象文字列"/>
	   <argument text="検索する文字列"/>
	</function>
	<function name="strstr" type="char*" content="char *strstr(const char *s, const char *t)">
	   <summary text="対象文字列から検索文字列を検索します。見つからない場合はNULLを返します。"/>
	   <argument text="検索対象文字列"/>
	   <argument text="検索する文字列"/>
	</function>
	<function name="strtok" type="char*" content="char *strtok(char *s, const char *t)">
	   <summary text="文字配列を、区切り文字列に含まれる文字がある位置で区切ります。区切られた単語へのポインタ、見つからない場合はNULLを返します。"/>
	   <argument text="文字配列"/>
	   <argument text="区切り文字列"/>
	</function>
	<function name="strerror" type="char*" content="char *strerror(int n)">
	   <summary text="エラーメッセージを取得します。エラーメッセージが格納された文字列、対応するエラーがないときは空文字列を返します。"/>
	   <argument text="エラー番号"/>
	</function>
	<function name="memcpy" type="void*" content="void *memcpy(void *dest, const void *source, size_t count)">
	   <summary text="メモリ内容をコピーします。コピー領域が重なっているとうまくいきません。重なっている場合はmemmove関数を使用してください。"/>
	   <argument text="コピー先"/>
	   <argument text="コピー元"/>
	   <argument text="コピーサイズ"/>
	</function>
	<function name="memmove" type="void*" content="void *memmove(void *dest, const void *source, size_t count)">
	   <summary text="メモリ内容をコピーします。コピー領域が重なっていても問題ありません。"/>
	   <argument text="コピー先"/>
	   <argument text="コピー元"/>
	   <argument text="コピーサイズ"/>
	</function>
	<function name="memset" type="void*" content="void *memset(void *addr, int byte, size_t count)">
	   <summary text="メモリ内容の指定サイズ分の要素全てに数値を代入します。文字にも使用できます。引数の配列をそのまま返します。"/>
	   <argument text="代入先配列"/>
	   <argument text="数値"/>
	   <argument text="代入サイズ"/>
	</function>
	<function name="memcmp" type="int" content="int memcmp(const void *addr1, const void *addr2, size_t n)">
	   <summary text="メモリ同士を比較します。文字列の比較も出来ます。配列1が大きいときは正、同じ時は0、配列2が大きいときは負を返します。"/>
	   <argument text="配列1"/>
	   <argument text="配列2"/>
	   <argument text="比較サイズ"/>
	</function>
	<function name="memchr" type="void*" content="void *memchr(const void *addr, int byte, size_t count)">
	   <summary text="メモリ内から数値を検索します。1文字検索にも使えます。見つかった位置のアドレス、見つからない場合はNULLを返します。"/>
	   <argument text="配列"/>
	   <argument text="１バイトの数値"/>
	   <argument text="検索するサイズ"/>
	</function>
</root>