﻿# coding : utf-8


import clr
clr.AddReference("System.Windows.Forms")
clr.AddReference("System.Drawing")

from System.Windows.Forms import *
from System.Drawing import *

def Keypress(sender,e):
   if e.KeyChar == '\r':
      e.Handled = True
      PressedOK(sender,e)


def PressedCancel(sender,e):
   fm = sender.FindForm()
   fm.Close()

def PressedOK(sender,e):
   fm = sender.FindForm()
   tb = fm.Controls[0]
   st = tb.Text
   try:
      num = int(st)
      linedata = " , &\\quad"
      iter = 0
      st = u"\\left\\{\r\n\\begin{array}{ll}\r\n"
      beginpoint = len(st)
      while iter < num:
         st += linedata
         if iter == num - 1:
            st += u"\r\n"
         else:
            st += u"  \\\\\r\n"
         iter += 1
      st += u"\\end{array}\r\n\\right.\r\n"
      begin,end = editor.Document.GetSelection()
      editor.Document.Replace(st,begin,end)
      editor.SetSelection(begin+beginpoint,begin+beginpoint)
      fm.Close()
   except ValueError:
      MessageBox.Show(u"テキストボックスの入力が数値ではありません")

fm = Form()
fm.MaximizeBox = False
fm.MinimizeBox = False
fm.FormBorderStyle = FormBorderStyle.FixedDialog
fm.ShowInTaskbar = False
fm.ShowIcon = False
fm.Text = u"場合分け"
fm.Size = Size(200,150)
okbut = Button()
okbut.Location = Point(95-okbut.Width,80)
okbut.Text = u"OK"
okbut.Click += PressedOK
cancelbut = Button()
cancelbut.Location = Point(105,80)
cancelbut.Text = u"Cancel"
cancelbut.Click += PressedCancel
lab = Label()
lab.AutoSize = True
lab.Text = u"いくつの場合がありますか？"
lab.Location = Point(10,10)
tb = TextBox()
tb.Location = Point(10,30)
tb.Width = 170
tb.KeyPress += Keypress
fm.Controls.Add(tb)
fm.Controls.Add(okbut)
fm.Controls.Add(cancelbut)
fm.Controls.Add(lab)
fm.StartPosition = FormStartPosition.CenterScreen
fm.ShowDialog()
