﻿using System;
using System.Collections.Generic;
using System.Text;

namespace NotepadNeueExtension
{
    /// <summary>
    /// プラグインが継承すべきクラスです。
    /// ドックコンテントとして追加されます（検索とかエクスプローラーのウィンドウのように）
    /// インターフェースではないですが、virtualの項目は全てoverrideしてください。
    /// </summary>
    public class CExtension : ExDockContent
    {
        /// <summary>
        /// 表示メニューおよびタブに表示される名前です。
        /// </summary>
        public virtual string ExtensionName
        {
            get;
            set;
        }

        /// <summary>
        /// ウィンドウの復元時に呼び出される文字列です。
        /// 特に意識しなくていいです。
        /// </summary>
        /// <returns></returns>
        protected override string GetPersistString()
        {
            return ExtensionName;
        }

        /// <summary>
        /// 初期化される時に呼び出されるメソッドです。
        /// IPluginHostの参照が与えられるのでメンバとして参照をとっておいた方がいいでしょう。
        /// </summary>
        /// <param name="Host">IPluginHostの参照</param>
        public virtual void Initialize(IExtensionHost Host)
        {
        }

        private void InitializeComponent()
        {
            this.SuspendLayout();
            // 
            // CExtension
            // 
            this.AutoScaleDimensions = new System.Drawing.SizeF(6F, 12F);
            this.ClientSize = new System.Drawing.Size(292, 266);
            this.HideOnClose = true;
            this.Name = "CExtension";
            this.ResumeLayout(false);
        }
    }
}
