﻿using System;
using System.Collections.Generic;
using System.Text;

namespace NotepadNeueExtension
{
    /// <summary>
    /// 定義値情報(#define)
    /// </summary>
    public class DefineValueInfo : AssistInformation
    {
        string value;
        string name;
        /// <summary>
        /// コンストラクタ
        /// </summary>
        public DefineValueInfo()
        {
            Image = NotepadNeueExtension.Properties.Resources.definevalue;
        }
        /// <summary>
        /// 名前(#define hoge 100 のhoge)
        /// </summary>
        public string Name
        {
            get
            {
                return name;
            }
            set
            {
                name = value;
            }
        }
        /// <summary>
        /// 値(#define hoge 100 の100)
        /// </summary>
        public string Value
        {
            get
            {
                return value;
            }
            set
            {
                this.value = value;
            }
        }
        /// <summary>
        /// 補完ウィンドウ表示テキスト(Nameを返す)
        /// </summary>
        public override string Text
        {
            get
            {
                return name;
            }
            set
            {
                name = value;
            }
        }
        /// <summary>
        /// ツールチップ表示ヒント(Valueを返す)
        /// </summary>
        public override string HintText
        {
            get
            {
                return value;
            }
            set
            {
                this.value = value;
            }
        }
    }
}
