﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Text;
using System.Linq;

namespace NotepadNeueExtension
{
    /// <summary>
    /// エディターアシストデータ
    /// </summary>
    public class EditorAssistData
    {
        private int caretpos;
        private int scrapedtime;
        /// <summary>
        /// ロードされたバッファ名
        /// </summary>
        public List<string> LoadedBufferName
        {
            get;
            private set;
        }
        /// <summary>
        /// 使用している名前空間
        /// </summary>
        public List<NameSpaceInfo> UsingNameSpace
        {
            get;
            private set;
        }
        /// <summary>
        /// グローバル(アクセス可能な)クラス
        /// </summary>
        public List<ObjectInfo> GlobalClass
        {
            get;
            private set;
        }
        /// <summary>
        /// グローバル(アクセス可能な)名前空間
        /// </summary>
        public List<NameSpaceInfo> GlobalNameSpace
        {
            get;
            private set;
        }
        /// <summary>
        /// グローバル(アクセス可能な)関数
        /// </summary>
        public List<FunctionInfo> GlobalFunction
        {
            get;
            private set;
        }
        /// <summary>
        /// グローバル(アクセス可能な)変数
        /// </summary>
        public List<VariableInfo> GlobalVariable
        {
            get;
            private set;
        }
        /// <summary>
        /// グローバル(アクセス可能な)定義値
        /// </summary>
        public List<DefineValueInfo> GlobalDefineValue
        {
            get;
            private set;
        }
        /// <summary>
        /// 変数、関数情報管理ツリー
        /// </summary>
        public BasicTree VariableDatas
        {
            get;
            private set;
        }
        /// <summary>
        /// エディタ
        /// </summary>
        public IEditorControl Editor
        {
            get;
            private set;
        }
        /// <summary>
        /// キャレットの位置(設定不要)
        /// </summary>
        public int CaretPos
        {
            set
            {
                caretpos = value;
                scrapedtime = System.Environment.TickCount;
            }
        }
        /// <summary>
        /// キャレットの位置を取得する
        /// ただし、キャレットの位置が設定された時間を考慮して返す
        /// </summary>
        /// <param name="pos"></param>
        /// <returns></returns>
        public int GetCaretPos(int pos)
        {
            if (System.Environment.TickCount - scrapedtime > 1000)
            {
                return pos;
            }
            return caretpos;
        }
        /// <summary>
        /// コンストラクタ
        /// </summary>
        public EditorAssistData(IEditorControl editor)
        {
            LoadedBufferName = new List<string>();
            UsingNameSpace = new List<NameSpaceInfo>();
            GlobalClass = new List<ObjectInfo>();
            GlobalNameSpace = new List<NameSpaceInfo>();
            GlobalFunction = new List<FunctionInfo>();
            GlobalVariable = new List<VariableInfo>();
            GlobalDefineValue = new List<DefineValueInfo>();
            VariableDatas = new BasicTree();
            Editor = editor;
        }

        public AssistInformation[] FindAssistInformation(string name)
        {
            IEnumerable<AssistInformation> iter = new AssistInformation[0];
            if (GlobalDefineValue != null)
            {
                iter = iter.Concat(GlobalDefineValue);
            }

            if (GlobalNameSpace != null)
            {
                iter = iter.Concat(GlobalNameSpace);
            }

            if (GlobalVariable != null)
            {
                iter = iter.Concat(GlobalVariable);
            }

            if (GlobalFunction != null)
            {
                iter = iter.Concat(GlobalFunction);
            }

            if (GlobalClass != null)
            {
                iter = iter.Concat(GlobalClass);
            }

            return iter.Where(i => i.Text == name).ToArray();
        }

        /// <summary>
        /// Nullに等しいか＝＝何も情報が入っていないか
        /// </summary>
        public bool IsEqualToNull
        {
            get
            {
                return LoadedBufferName.Count == 0 && UsingNameSpace.Count == 0 && GlobalClass.Count == 0 &&
                  GlobalFunction.Count == 0 && GlobalNameSpace.Count == 0 && GlobalVariable.Count == 0 &&
                  GlobalDefineValue.Count == 0 && VariableDatas.Variables.Length == 0 && VariableDatas.Functions.Length == 0 &&
                  VariableDatas.VariableOrTrees.Length == 0;
            }
        }
    }
}
