﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Text;

namespace NotepadNeueExtension
{
    /// <summary>
    /// 関数情報
    /// </summary>
    public class FunctionInfo : VariableInfo
    {
        List<string> contents;
        List<string[]> args;
        int shoulddisplaynum;
        /// <summary>
        /// コンストラクタ
        /// </summary>
        public FunctionInfo()
        {
            Image = NotepadNeueExtension.Properties.Resources.function;
            contents = new List<string>();
            args = new List<string[]>();
            shoulddisplaynum = 0;
        }
        /// <summary>
        /// コンテント追加
        /// </summary>
        /// <param name="content"></param>
        public void AddContent(string content)
        {
            contents.Add(content);
        }
        /// <summary>
        /// コンテント
        /// </summary>
        public List<string> Content
        {
            get
            {
                return contents;
            }
        }
        /// <summary>
        /// 引数
        /// </summary>
        public List<string[]> Argument
        {
            get
            {
                return args;
            }
        }
        /// <summary>
        /// 引数追加
        /// </summary>
        /// <param name="args"></param>
        public void AddArgument(string[] args)
        {
            this.args.Add(args);
        }
        /// <summary>
        /// 特定のコンテント
        /// </summary>
        /// <param name="index"></param>
        /// <returns></returns>
        public string ContentAt(int index)
        {
            if (contents.Count <= index)
            {
                return "";
            }
            return contents[index];
        }
        /// <summary>
        /// 特定の引数
        /// </summary>
        /// <param name="index"></param>
        /// <returns></returns>
        public string[] ArgumentsAt(int index)
        {
            if (args.Count <= index)
            {
                return new string[0];
            }
            return args[index];
        }
        /// <summary>
        /// 現在フォーカスされているコンテントの特定の引数
        /// </summary>
        /// <param name="index"></param>
        /// <returns></returns>
        public string ArgumentFromCurrent(int index)
        {
            if (shoulddisplaynum >= args.Count) return "";
            string[] pool = args[shoulddisplaynum];
            if (index < 0 || index >= pool.Length) return "";
            return pool[index];
        }
        /// <summary>
        /// コンテントが２以上ある場合に"オーバーライド"を付けて返す
        /// </summary>
        public string NumOfOverride
        {
            get
            {
                if (contents.Count > 1)
                {
                    return "  +" + (contents.Count - 1).ToString() + "オーバーライド";
                }
                else
                {
                    return "";
                }
            }
        }
        /// <summary>
        /// コンテントの数
        /// </summary>
        public int ContentCount
        {
            get
            {
                return contents.Count;
            }
        }
        /// <summary>
        /// 同じコンテントをすでに含んでいるか
        /// </summary>
        /// <param name="content"></param>
        /// <returns></returns>
        public bool ContainsSameContent(string content)
        {
            return contents.Contains(content);
        }
        /// <summary>
        /// 現在フォーカスされているコンテントのインデックス
        /// </summary>
        public int Displaynum
        {
            get
            {
                return shoulddisplaynum;
            }
            set
            {
                shoulddisplaynum = value;
            }
        }
        /// <summary>
        /// コンテントのフォーカスインデックスを加減する
        /// </summary>
        /// <param name="dx"></param>
        public void GainDisplayNum(int dx)
        {
            shoulddisplaynum += dx;
            if (shoulddisplaynum < 0) shoulddisplaynum = contents.Count - 1;
            if (shoulddisplaynum >= contents.Count) shoulddisplaynum = 0;
        }
        /// <summary>
        /// ツールチップのヒント表示(ContentAt(Displaynum) + NumOfOverride)
        /// </summary>
        public override string HintText
        {
            get
            {
                return ContentAt(Displaynum) + NumOfOverride;
            }
            set
            {

            }
        }
    }
}
