﻿using System;
using System.Collections.Generic;
using System.Text;

namespace NotepadNeueExtension
{
    class TemplateObjectInfo : ObjectInfo
    {
        ObjectInfo templateobject;
        List<KeyValuePair<string, string>> templates;
        public TemplateObjectInfo()
        {
            templates = new List<KeyValuePair<string, string>>();
        }
        public ObjectInfo TemplateObject
        {
            get
            {
                return templateobject;
            }
            set
            {
                templateobject = value;
            }
        }
        public void AddTemplateType(string templatetype, string truetype)
        {
            templates.Add(new KeyValuePair<string, string>(templatetype, truetype));
        }
        public int TemplateTypeCount
        {
            get
            {
                return templates.Count;
            }
        }
        public override DefineValueInfo[] GetAllDefineValue()
        {
            if (templateobject == null)
            {
                return new DefineValueInfo[0];
            }
            return templateobject.GetAllDefineValue();
        }
        public override FunctionInfo[] GetAllFunction()
        {
            List<FunctionInfo> ret = new List<FunctionInfo>();
            if (templateobject == null)
            {
                return ret.ToArray();
            }
            foreach (FunctionInfo fi in templateobject.GetAllFunction())
            {
                FunctionInfo trans = new FunctionInfo();
                trans.AccessType = fi.AccessType;
                trans.Displaynum = fi.Displaynum;
                foreach (string content in fi.Content)
                {
                    string temp = content;
                    foreach (KeyValuePair<string, string> kvp in templates)
                    {
                        temp = temp.Replace(kvp.Key + " ", kvp.Value + " ");
                    }
                    trans.AddContent(temp);
                }
                foreach (string[] arg in fi.Argument)
                {
                    trans.AddArgument(arg);
                }
                string type = fi.Type;
                foreach (KeyValuePair<string, string> kvp in templates)
                {
                    type = type.Replace(kvp.Key + " ", kvp.Value + " ");
                }
                trans.Type = type;
                ret.Add(trans);
            }
            return ret.ToArray();
        }
        public override FunctionInfo[] GetAllFunction(AccessType accesstype)
        {
            List<FunctionInfo> ret = new List<FunctionInfo>();
            if (templateobject == null)
            {
                return ret.ToArray();
            }
            foreach (FunctionInfo fi in templateobject.GetAllFunction(accesstype))
            {
                FunctionInfo trans = new FunctionInfo();
                trans.AccessType = fi.AccessType;
                trans.Displaynum = fi.Displaynum;
                foreach (string content in fi.Content)
                {
                    string temp = content;
                    foreach (KeyValuePair<string, string> kvp in templates)
                    {
                        temp = temp.Replace(kvp.Key + " ", kvp.Value + " ");
                    }
                    trans.AddContent(temp);
                }
                foreach (string[] arg in fi.Argument)
                {
                    trans.AddArgument(arg);
                }
                string type = fi.Type;
                foreach (KeyValuePair<string, string> kvp in templates)
                {
                    type = type.Replace(kvp.Key + " ", kvp.Value + " ");
                }
                trans.Type = type;
                ret.Add(trans);
            }
            return ret.ToArray();
        }
        public override VariableInfo[] GetAllVariable()
        {
            List<VariableInfo> ret = new List<VariableInfo>();
            if (templateobject == null)
            {
                return ret.ToArray();
            }
            foreach (VariableInfo vi in templateobject.GetAllVariable())
            {
                VariableInfo trans = new VariableInfo();
                trans.DefineLocation = vi.DefineLocation;
                trans.Name = vi.Name;
                trans.AccessType = vi.AccessType;
                string type = vi.Type;
                foreach (KeyValuePair<string, string> kvp in templates)
                {
                    type = type.Replace(kvp.Key + " ", kvp.Value + " ");
                }
                trans.Type = type;
                ret.Add(trans);
            }
            return ret.ToArray();
        }
        public override VariableInfo[] GetAllVariable(AccessType accesstype)
        {
            List<VariableInfo> ret = new List<VariableInfo>();
            if (templateobject == null)
            {
                return ret.ToArray();
            }
            foreach (VariableInfo vi in templateobject.GetAllVariable(accesstype))
            {
                VariableInfo trans = new VariableInfo();
                trans.DefineLocation = vi.DefineLocation;
                trans.Name = vi.Name;
                trans.AccessType = vi.AccessType;
                string type = vi.Type;
                foreach (KeyValuePair<string, string> kvp in templates)
                {
                    type = type.Replace(kvp.Key + " ", kvp.Value + " ");
                }
                trans.Type = type;
                ret.Add(trans);
            }
            return ret.ToArray();
        }
        public override VariableInfo GetVariableInfo(string name)
        {
            if (templateobject == null)
            {
                return null;
            }
            VariableInfo vi = templateobject.GetVariableInfo(name);
            VariableInfo trans = new VariableInfo();
            trans.DefineLocation = vi.DefineLocation;
            trans.Name = vi.Name;
            trans.AccessType = vi.AccessType;
            string type = vi.Type;
            foreach (KeyValuePair<string, string> kvp in templates)
            {
                type = type.Replace(kvp.Key + " ", kvp.Value + " ");
            }
            trans.Type = type;
            return trans;
        }
        public override string HintText
        {
            get
            {
                return base.HintText;
            }
            set
            {
                base.HintText = value;
            }
        }
        public override string Summary
        {
            get
            {
                return base.Summary;
            }
            set
            {
                base.Summary = value;
            }
        }
        public override string Text
        {
            get
            {
                return base.Text;
            }
            set
            {
                base.Text = value;
            }
        }
        public override string Name
        {
            get
            {
                if (templateobject == null) return "";
                string name = templateobject.Name;
                string before = name, after = "";
                int iter = 0;
                while (iter < name.Length)
                {
                    char c = name[iter];
                    if (Char.IsLetterOrDigit(c) || Char.IsWhiteSpace(c)) continue;
                    before = name.Substring(0, iter);
                    after = name.Substring(iter);
                }
                foreach (KeyValuePair<string, string> kvp in templates)
                {
                    after = after.Replace(kvp.Key + " ", kvp.Value + " ");
                }
                return before + after;
            }
            set
            {

            }
        }
    }
}
