﻿using System;
using System.Collections.Generic;
using System.Text;

namespace NotepadNeueExtension
{
    /// <summary>
    /// アクセスタイプ
    /// </summary>
    public enum AccessType
    {
        /// <summary>
        /// プライベート
        /// </summary>
        Private = 0,
        /// <summary>
        /// プロテクト
        /// </summary>
        Protected = 1,
        /// <summary>
        /// パブリック
        /// </summary>
        Public = 2
    }

    /// <summary>
    /// 初期化属性
    /// </summary>
    public enum InitializeType
    {
        /// <summary>
        /// 通常
        /// </summary>
        Normal = 0,
        /// <summary>
        /// 静的
        /// </summary>
        Static = 1
    }
    /// <summary>
    /// 変数情報クラス
    /// </summary>
    public class VariableInfo : AssistInformation
    {
        string type;
        string name;
        AccessType accesstype;
        InitializeType initializetype;
        /// <summary>
        /// コンストラクタ
        /// </summary>
        public VariableInfo()
        {
            Image = NotepadNeueExtension.Properties.Resources.variable;
            accesstype = AccessType.Public;
            initializetype = InitializeType.Normal;
        }
        /// <summary>
        /// アクセスタイプ
        /// </summary>
        public AccessType AccessType
        {
            get
            {
                return accesstype;
            }
            set
            {
                accesstype = value;
            }
        }
        /// <summary>
        /// 初期化属性
        /// </summary>
        public InitializeType InitializeType
        {
            get
            {
                return initializetype;
            }
            set
            {
                initializetype = value;
            }
        }
        /// <summary>
        /// 名前
        /// </summary>
        public string Name
        {
            get
            {
                return name;
            }
            set
            {
                name = value;
            }
        }
        /// <summary>
        /// 型の名前
        /// </summary>
        public string Type
        {
            get
            {
                return type;
            }
            set
            {
                type = value;
            }
        }
        /// <summary>
        /// 補完ウィンドウ表示テキスト(Nameを返す)
        /// </summary>
        public override string Text
        {
            get
            {
                return name;
            }
            set
            {
                name = value;
            }
        }
        /// <summary>
        /// ツールチップ表示ヒント(Typeを返す)
        /// </summary>
        public override string HintText
        {
            get
            {
                return type;
            }
            set
            {
                type = value;
            }
        }

        public BasicTree ParentTree
        {
            get;
            internal set;
        }
    }
}
