﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using WeifenLuo.WinFormsUI.Docking;
namespace NotepadNeueExtension
{
    public partial class ExDockContent : DockContent
    {
        /// <summary>
        /// 背景が変更される前に呼び出される。
        /// </summary>
        public event EventHandler BeforeChangeBackGround;

        Timer timer;
        /// <summary>
        /// コンストラクタ
        /// </summary>
        public ExDockContent()
        {
            InitializeComponent();
            timer = new Timer();
            timer.Interval = 1000;
            timer.Tick += new EventHandler(timer_Tick);
        }
        void timer_Tick(object sender, EventArgs e)
        {
            this.SuspendLayout();
            getbackground();
            timer.Stop();
            this.ResumeLayout();
        }
        private void getbackground()
        {
            if (DockPanel != null && DockPanel.BackgroundImage != null && Pane != null && Pane.Size.Width > 0 && Pane.Size.Height > 0)
            {
                if (DockState == DockState.Float)
                {
                    Bitmap bit = new Bitmap(1000, 1000);
                    Graphics g = Graphics.FromImage(bit);
                    SolidBrush sb = new SolidBrush(SystemColors.Control);
                    g.FillRectangle(sb, new Rectangle(0, 0, bit.Width, bit.Height));
                    if (BeforeChangeBackGround != null)
                    {
                        BeforeChangeBackGround.Invoke(this, EventArgs.Empty);
                    }
                    this.BackgroundImage = bit;
                    sb.Dispose();
                }
                else
                {
                    //Console.WriteLine(GetPointFromDockPanel(Pane));
                    Point p = GetPointFromDockPanel(Pane);
                    if (DockState == DockState.DockRight)
                    {
                        p = new Point(p.X, p.Y + 18);
                    }
                    else if (DockState == DockState.DockLeft)
                    {
                        p = new Point(p.X, p.Y + 18);
                    }
                    else if (DockState == DockState.DockTop)
                    {
                        p = new Point(p.X, p.Y + 18);
                    }
                    else if (DockState == DockState.DockBottom)
                    {
                        p = new Point(p.X, p.Y + 18);
                    }
                    else if (DockState == DockState.Document)
                    {
                        p = new Point(p.X, p.Y + 24);
                    }
                    Bitmap bit = new Bitmap(Pane.Size.Width, Pane.Size.Height);
                    Graphics g = Graphics.FromImage(bit);

                    g.DrawImage(DockPanel.BackgroundImage, new Rectangle(0, 0, Pane.Size.Width, Pane.Size.Height), new Rectangle(p.X, p.Y, Pane.Size.Width, Pane.Size.Height), GraphicsUnit.Pixel);
                    SolidBrush sb = new SolidBrush(Color.FromArgb(220, 255, 255, 255));
                    if (Skin != null)
                    {
                        sb.Dispose();
                        sb = new SolidBrush(Skin.OverLayColor);
                    }
                    g.FillRectangle(sb, new Rectangle(0, 0, Pane.Size.Width, Pane.Size.Height));
                    sb.Dispose(); 
                    if (BeforeChangeBackGround != null)
                    {
                        BeforeChangeBackGround.Invoke(this, EventArgs.Empty);
                    }
                    this.BackgroundImage = bit;
                }
            }
        }
        private Point GetPointFromDockPanel(DockPane pane)
        {
            Point ret = new Point(0, 0);
            Control c = pane;
            while (c != null && !(c is DockPanel))
            {
                ret = new Point(ret.X + c.Location.X, ret.Y + c.Location.Y);
                c = c.Parent;
            }
            return ret;
        }
        private NotepadNeueSkin Skin
        {
            get
            {
                if (DockPanel != null && DockPanel.FindForm() is IExtensionHost)
                {
                    IExtensionHost fm1 = DockPanel.FindForm() as IExtensionHost;
                    return fm1.Skin;
                }
                return null;
            }
        }

        private void ExDockContent_DockStateChanged(object sender, EventArgs e)
        {
            timer.Start();
        }

        private void ExDockContent_SizeChanged(object sender, EventArgs e)
        {
            timer.Start();
        }
    }
}
