﻿using System;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.IO;
using System.Collections.Generic;
using System.Text.RegularExpressions;
using System.Windows.Forms;
using System.Text;

using WeifenLuo.WinFormsUI.Docking;

namespace NotepadNeueExtension
{
    /// <summary>
    /// 背景の表示方法
    /// </summary>
    public enum BackGroundDisplayMode
    {
        /// <summary>
        /// 右寄せ
        /// </summary>
        right = 0,
        /// <summary>
        /// 左寄せ
        /// </summary>
        left = 1,
        /// <summary>
        /// センター
        /// </summary>
        center = 2,
        /// <summary>
        /// 充填
        /// </summary>
        fill = 3
    }
    /// <summary>
    /// スキンインターフェース
    /// </summary>
    public interface NotepadNeueSkin
    {
        /// <summary>
        /// 初期化メソッド
        /// </summary>
        /// <param name="filename">スキン設定ファイルパス</param>
        /// <param name="currentdirectory">カレントディレクトリ</param>
        void Initialize(string filename, string currentdirectory);
        /// <summary>
        /// 背景の画像
        /// </summary>
        Bitmap BackGround
        {
            get;
            set;
        }
        /// <summary>
        /// オーバーレイの色
        /// </summary>
        Color OverLayColor
        {
            get;
            set;
        }
        /// <summary>
        /// 余ったスペースに塗る色
        /// </summary>
        Color FillColor
        {
            get;
            set;
        }
        /// <summary>
        /// 枠の色
        /// </summary>
        Color BorderColor
        {
            get;
            set;
        }
        /// <summary>
        /// 背景描画方法
        /// </summary>
        BackGroundDisplayMode DisplayMode
        {
            get;
            set;
        }
        /// <summary>
        /// スキン
        /// </summary>
        DockPanelSkin Skin
        {
            get;
            set;
        }
        /// <summary>
        /// 透過テキストカラー
        /// </summary>
        Color TransparentTextColor
        {
            get;
            set;
        }
    }
}
