﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace ParseExtension
{
    class CTokenizer : OperatorTokenizerBase
    {
        string[] opes = new string[]{
            "++",
            "--",
            "+=",
            "-=",
            "*=",
            "/=",
            "->",
            "==",
            "!=",
            "&=",
            "^=",
            "|=",
            "||",
            "&&",
        };

        public override string[] Operations
        {
            get { return opes; }
        }

        public CTokenizer()
            : base(new ParseEnclosure[]{
                new ParseEnclosure("<?",null,null,false, TokenType.Comment),
                new ParseEnclosure("/*","*/",null,true, TokenType.Comment),
                new ParseEnclosure("//",null,null,false, TokenType.Comment),
                new ParseEnclosure("'","'","\\",false, TokenType.Literal),
                new ParseEnclosure("\"","\"","\\",false, TokenType.Literal),
            }, true)
        {

        }

        protected override ParseToken[] JoinFree(ParseToken[] tokens)
        {
            List<ParseToken> ret = new List<ParseToken>();
            for (int i = 0; i < tokens.Length; i++)
            {
                switch (tokens[i].TokenType)
                {
                    case TokenType.Symbol:
                        if (tokens[i].Token == "#")
                        {
                            int next = SkipTo(TokenType.LetterOrDigit, i + 1, tokens);
                            if (next < tokens.Length)
                            {
                                tokens[i].TokenType = TokenType.LetterOrDigit;
                                ret.Add(tokens[i].Join(tokens[next]));
                                i = next;
                                continue;
                            }
                        }
                        else if (tokens[i].Token == "else")
                        {
                            int next = SkipTo("if", TokenType.LetterOrDigit,
                                new TokenType[] { TokenType.LetterOrDigit, TokenType.WhiteSpace, TokenType.NewLine },
                                i + 1, tokens);
                            if (next < tokens.Length)
                            {
                                ret.Add(new ParseToken("else if", tokens[i].Index, TokenType.LetterOrDigit));
                                i = next;
                                continue;
                            }
                        }
                        goto default;
                    default:
                        ret.Add(tokens[i]);
                        break;
                }
            }
            return ret.ToArray();
        }
    }
}
