﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Text.RegularExpressions;
using NotepadNeueExtension;
using System.IO;

namespace ParseExtension
{
    class CWordChecker : IWordChecker
    {
        static Dictionary<string, FileListCache> bufferNameCache = new Dictionary<string, FileListCache>();
        static Regex includeRegex = new Regex(" *#include *(?<ope>[<\"]) *(?<filename>.*)$");

        IExtensionHost host;
        public CWordChecker(IExtensionHost host)
        {
            this.host = host;
        }
        #region IWordChecker メンバ

        public bool CheckWord(NotepadNeueExtension.CheckWordEventArgs e)
        {
            string checkText = e.Document.GetLineContent(e.Document.GetLineIndexFromCharIndex(e.CaretIndex));
            if (e.CaretIndex == e.Range.Start && e.CaretIndex == e.Range.End && checkText != "")
            {
                Match match = includeRegex.Match(checkText);
                if (match.Success)
                {
                    string dir = host.GetBufferDirectory(e.FileName);
                    if (Directory.Exists(dir))
                    {
                        int i = 0;
                        int index = -1;
                        foreach (string filePath in GetFiles(dir))
                        {
                            string ope = match.Groups["ope"].Value;
                            string filename = Path.GetFileName(filePath);
                            string replaceText = String.Format("{0}{1}{2}", ope, filename, ope == "<" ? ">" : "\"");

                            if (index < 0 && filename.StartsWith(match.Groups["filename"].Value))
                            {
                                index = i;
                            }

                            e.AssistInformations.Add(new AssistInformation()
                            {
                                Text = replaceText,
                                HintText = replaceText,
                                Summary = "",
                                Image = Properties.Resources.buffer_icon
                            });
                            i++;
                        }

                        e.SelectIndex = index;
                        return true;
                    }
                }
            }

            return false;
        }

        private string[] GetFiles(string dir)
        {
            FileListCache fileListCache;
            if (!bufferNameCache.ContainsKey(dir))
            {
                fileListCache = new FileListCache(dir);
                bufferNameCache.Add(dir, fileListCache);
            }
            else
            {
                fileListCache = bufferNameCache[dir];
                fileListCache.CheckUpdate();
            }

            return fileListCache.Files;
        }

        private string GetCurrentLineText(string text, int index)
        {
            int foundIndex = text.LastIndexOfAny(new char[] { '\r', '\n' }, index);

            if (foundIndex < 0)
            {
                return text.Substring(0, index + 1);
            }
            else
            {
                return text.Substring(foundIndex + 1, index - foundIndex);
            }
        }

        class FileListCache
        {
            public FileListCache(string dir)
            {
                Dir = dir;
                LastWriteTime = Directory.GetLastWriteTime(dir);
                Files = Directory.GetFiles(dir);
            }

            public string Dir
            {
                get;
                private set;
            }

            public DateTime LastWriteTime
            {
                get;
                private set;
            }

            public string[] Files
            {
                get;
                private set;
            }

            public void CheckUpdate()
            {
                DateTime lastWrite = Directory.GetLastWriteTime(Dir);
                if (lastWrite.CompareTo(LastWriteTime) > 0)
                {
                    Files = Directory.GetFiles(Dir);
                    LastWriteTime = lastWrite;
                }
            }
        }

        #endregion
    }
}
