﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.IO;

using NotepadNeueExtension;
using System.Threading;

namespace ParseExtension
{
    public partial class ParseExtension : CExtension
    {
        enum ParseEnum
        {
            C = 0,
            Fortran,
            JavaScript,
            Php,
            Keyword,
            Html,
            Tex
        }

        string settingdir = "";
        public override string ExtensionName
        {
            get
            {
                return "パースマネージャー";
            }
            set
            {
            }
        }
        /// <summary>
        /// Hostの参照
        /// </summary>
        public IExtensionHost Host
        {
            get;
            set;
        }
        //NotepadNeue内から呼び出されます。
        //Windowsアプリケーションとしてコンパイルしている間は呼び出されないので注意してください。
        public override void Initialize(IExtensionHost Host)
        {
            InitializeComponent();
            this.Host = Host;
            Host.MainFormClosed += new EventHandler(Host_MainFormClosed);
            Host.ParseStarted += new ParseEventHandler(Host_ParseStarted);
            Host.CheckWordStarted += new CheckWordEventHandleer(Host_CheckWordStarted);
            dataGridView1.Rows.Add("C", true, true);
            dataGridView1.Rows.Add("Fortran", true, true);
            dataGridView1.Rows.Add("JavaScript", true, true);
            dataGridView1.Rows.Add("Php", true, true);
            dataGridView1.Rows.Add("KeyWord", true, true);
            dataGridView1.Rows.Add("HTML,XML", true, true);
            dataGridView1.Rows.Add("Tex", true, true);
            settingdir = Host != null ? Host.CurrentDirectory : "";
            for (int i = 0; i < dataGridView1.RowCount; i++)
            {
                (dataGridView1[1, i] as DataGridViewCheckBoxCell).TrueValue = true;
                (dataGridView1[2, i] as DataGridViewCheckBoxCell).TrueValue = true;
                (dataGridView1[1, i] as DataGridViewCheckBoxCell).FalseValue = false;
                (dataGridView1[2, i] as DataGridViewCheckBoxCell).FalseValue = false;
            }
            ReadSetting();
        }

        void ReadSetting()
        {
            for (int i = 0; i < dataGridView1.RowCount; i++)
            {
                string data = Host.GetSetting("ParseExtension", dataGridView1[0, i].Value.ToString());
                if (data != null && data.Length == 2)
                {
                    dataGridView1[1, i].Value = data[0] == '1';
                    dataGridView1[2, i].Value = data[1] == '1';
                }
            }
        }
        void Host_ParseStarted(ParseEventArgs e)
        {
            IParser parser = null;
            if (e.Extension == "c" && IsChecked(ParseEnum.C))
            {
                parser = new CParser(Host);
            }
            else if ((e.Extension == "f" || e.Extension == "f90") && IsChecked(ParseEnum.Fortran))
            {
                parser = new FortranParser(Host);
            }
            else if (e.Extension == "js" && IsChecked(ParseEnum.JavaScript))
            {
                parser = new JavaScriptParser(Host);
            }
            else if (e.Extension == "php" && IsChecked(ParseEnum.Php))
            {
                parser = new PhpParser(Host);
            }
            else if (IsChecked(ParseEnum.Keyword))
            {
                parser = new WordParser();
            }
            else
            {
                parser = new SpellParser(Host);
            }

            if (parser != null)
            {
                try
                {
                    parser.Parse(e);
                }
                catch (ThreadAbortException)
                {
                }
                catch (Exception ex)
                {
#if DEBUG
                    MessageBox.Show(String.Format("{0}\n{1}", ex.Message, ex.StackTrace));
#endif
                }
                e.Handled = true;
            }
        }

        void Host_CheckWordStarted(CheckWordEventArgs e)
        {
            IWordChecker wordChecker = null;
            if (e.Extension == "c")
            {
                wordChecker = new CWordChecker(Host);
            }
            else if ((e.Extension == "htm" || e.Extension == "html" || e.Extension == "xml") && IsChecked(ParseEnum.Html))
            {
                wordChecker = new XmlWordChecker();
            }
            else if (e.Extension == "tex" && IsChecked(ParseEnum.Tex))
            {
                wordChecker = new TexWordChecker();
            }

            if (wordChecker != null)
            {
                try
                {
                    e.Handled = wordChecker.CheckWord(e);
                }
                catch (ThreadAbortException)
                {
                }
                catch (Exception ex)
                {
#if DEBUG
                    MessageBox.Show(String.Format("{0}\n{1}", ex.Message, ex.StackTrace));
#endif
                }
            }
        }

        private bool IsChecked(ParseEnum parseEnum)
        {
            return (bool)(dataGridView1[1, (int)parseEnum] as DataGridViewCheckBoxCell).Value;
        }

        void Host_MainFormClosed(object sender, EventArgs e)
        {
            for (int i = 0; i < dataGridView1.RowCount; i++)
            {
                string data = "";
                data += (bool)dataGridView1[1, i].Value ? "1" : "0";
                data += (bool)dataGridView1[2, i].Value ? "1" : "0";
                Host.SetSetting("ParseExtension", dataGridView1[0, i].Value.ToString(), data);
            }
        }
        //このコンストラクタはWindowsアプリケーションとしてコンパイルする場合に使用してください。
        //クラスライブラリとしてコンパイルする場合にはコメントアウトしてください。
        /*public ParseExtension()
        {
            InitializeComponent();
            dataGridView1.Rows.Add("C", 1, 1);
        }*/
    }
}
