﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace ParseExtension
{
    class ParseToken
    {
        public string Token
        {
            get;
            private set;
        }

        public int Index
        {
            get;
            private set;
        }

        public TokenType TokenType
        {
            get;
            set;
        }

        public ParseToken(string token, int index, TokenType tokenType)
        {
            Token = token;
            Index = index;
            TokenType = tokenType;
        }

        public ParseToken Join(ParseToken token)
        {
            TokenType resultTokenType = TokenType.LetterOrDigit;
            switch (TokenType)
            {
                case TokenType.LetterOrDigit:
                    if (TokenType != TokenType.LetterOrDigit)
                    {
                        throw new Exception("Not Suitable TokenType");
                    }
                    resultTokenType = TokenType.LetterOrDigit;
                    break;
                case TokenType.Comment:
                    resultTokenType = TokenType.Comment;
                    break;
                case TokenType.Literal:
                    resultTokenType = TokenType.Comment;
                    break;
                case TokenType.NewLine:
                    if (token.TokenType != TokenType.NewLine)
                    {
                        throw new Exception("Not Suitable TokenType");
                    }
                    resultTokenType = TokenType.NewLine;
                    break;
                case TokenType.Symbol:
                    if (token.TokenType != TokenType.Symbol)
                    {
                        throw new Exception("Not Suitable TokenType");
                    }
                    resultTokenType = TokenType.Symbol;
                    break;
                case TokenType.WhiteSpace:
                    if (token.TokenType != TokenType.WhiteSpace)
                    {
                        throw new Exception("Not Suitable TokenType");
                    }
                    resultTokenType = TokenType.WhiteSpace;
                    break;
            }

            return new ParseToken(String.Format("{0}{1}", Token, token.Token), Index, resultTokenType);
        }

        public override string ToString()
        {
            return String.Format("{0}_{1}:{2}", Index, TokenType, Token);
        }
    }
}
