﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using NotepadNeueExtension;

namespace ParseExtension
{
    abstract class ParserBase : IParser
    {
        public IExtensionHost Host
        {
            get;
            private set;
        }

        public abstract TokenizerBase Tokenizer
        {
            get;
        }

        public ParserBase(IExtensionHost host)
        {
            Host = host;
        }

        public void Parse(NotepadNeueExtension.ParseEventArgs e)
        {
            TokenizerBase tokenizer = Tokenizer;
            tokenizer.Tokenize(e.ParseText);
            e.AssistData.VariableDatas.Start = 0;
            e.AssistData.VariableDatas.End = e.ParseText.Length;
            Console.WriteLine("Parse Start:{0}", Environment.TickCount);
            ParseImpl(0, tokenizer.Tokens, e.AssistData.VariableDatas, null, e);
            ParseEnd(e);
            Console.WriteLine("Parse End:{0}", Environment.TickCount);
        }

        protected virtual int ParseImpl(int i, ParseToken[] tokens, BasicTree tree, ObjectInfo objectInfo,
            NotepadNeueExtension.ParseEventArgs e)
        {
            return 0;
        }

        protected virtual void ParseEnd(NotepadNeueExtension.ParseEventArgs e)
        {

        }

        protected int SkipTo(TokenType tokenType, int index, ParseToken[] tokens)
        {
            return SkipTo("", tokenType, index, tokens);
        }

        protected int SkipTo(string token, TokenType tokenType, int index, ParseToken[] tokens)
        {
            return SkipTo(token, tokenType, index, tokens.Length, tokens);
        }

        protected int SkipTo(string token, TokenType tokenType, int index, int endIndex, ParseToken[] tokens)
        {
            for (int i = index; i < endIndex; i++)
            {
                if (!String.IsNullOrEmpty(token))
                {
                    if (tokens[i].Token == token && tokens[i].TokenType == tokenType)
                    {
                        return i;
                    }
                }
                else
                {
                    if (tokens[i].TokenType == tokenType)
                    {
                        return i;
                    }
                }
            }

            return tokens.Length;
        }

        protected int SkipTo(string[] token, TokenType tokenType, int index, ParseToken[] tokens)
        {
            return SkipTo(token, tokenType, index, tokens.Length, tokens);
        }

        protected int SkipTo(string[] token, TokenType tokenType, int index, int endIndex, ParseToken[] tokens)
        {
            for (int i = index; i < endIndex; i++)
            {
                if (token.Contains(tokens[i].Token) && tokens[i].TokenType == tokenType)
                {
                    return i;
                }
            }

            return tokens.Length;
        }

        protected int SkipToMatchedBrace(int index, ParseToken[] tokens)
        {
            if (index < 0)
            {
                throw new Exception("Invalid Index");
            }

            int count = 0;
            for (int i = index; i < tokens.Length; i++)
            {
                if (tokens[i].TokenType == TokenType.Symbol)
                {
                    switch (tokens[i].Token)
                    {
                        case "(":
                            count++;
                            break;
                        case ")":
                            count--;
                            if (count == 0)
                            {
                                return i;
                            }
                            break;
                    }
                }
            }

            return tokens.Length;
        }
    }
}
