﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace ParseExtension
{
    class PhpTokenizer : OperatorTokenizerBase
    {
        string[] opes = new string[]{
            "===",
            "!==",
            "++",
            "--",
            "+=",
            "-=",
            "*=",
            "/=",
            "->",
            "=>",
            "==",
            "!=",
            "&=",
            "^=",
            "|=",
            "||",
            "&&",
        };

        public override string[] Operations
        {
            get { return opes; }
        }

        public PhpTokenizer()
            : base(new ParseEnclosure[]{
                new ParseEnclosure("<?",null,null,false, TokenType.Comment),
                new ParseEnclosure("/*","*/",null,true, TokenType.Comment),
                new ParseEnclosure("//",null,null,false, TokenType.Comment),
                new ParseEnclosure("'","'","\\",false, TokenType.Literal),
                new ParseEnclosure("\"","\"","\\",false, TokenType.Literal),
            }, true)
        {
        }

        protected override ParseToken[] JoinFree(ParseToken[] tokens)
        {
            List<ParseToken> ret = new List<ParseToken>();
            int iter = 0;
            while (iter < tokens.Length)
            {
                if (tokens[iter].TokenType == TokenType.Symbol && tokens[iter].Token == "$")
                {
                    int next = SkipTo(TokenType.LetterOrDigit, iter + 1, tokens);
                    if (next < tokens.Length)
                    {
                        tokens[iter].TokenType = TokenType.LetterOrDigit;
                        ret.Add(tokens[iter].Join(tokens[next]));
                        iter = next;
                    }
                }
                else
                {
                    ret.Add(tokens[iter]);
                }
                iter++;
            }
            return ret.ToArray();
        }
    }
}