﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace ParseExtension.RegularExpressions
{
    class ParserRegexBackTrack
    {
        public ParserRegexNode Node
        {
            get;
            private set;
        }

        public ParserRegexBackTrack BackTrack
        {
            get;
            private set;
        }

        public int UsedIndex
        {
            get;
            private set;
        }

        public ParserRegexExpression Expression
        {
            get;
            private set;
        }

        public int Length
        {
            get;
            private set;
        }

        public ParserRegexBackTrack(ParserRegexNode node, ParserRegexBackTrack backTrack) :
            this(node, backTrack, -1, null)
        {

        }

        public ParserRegexBackTrack(ParserRegexNode node, ParserRegexBackTrack backTrack,
            int usedIndex, ParserRegexExpression expression)
        {
            BackTrack = backTrack;
            Node = node;
            UsedIndex = usedIndex;
            Expression = expression;
            if (backTrack != null)
            {
                Length = backTrack.Length + 1;
            }
        }
    }
}
