﻿using System;
using NHunspell;
using NotepadNeueExtension;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;

namespace ParseExtension
{
    class SpellParser : ParserBase
    {
        static Hunspell hunspell;
        NormalTokenizer tokenizer;

        public override TokenizerBase Tokenizer
        {
            get { return tokenizer; }
        }

        static SpellParser()
        {
            hunspell = new Hunspell(@"extension\dict\en_US.aff", @"extension\dict\en_US.dic");
        }

        public SpellParser(IExtensionHost host)
            : base(host)
        {
            tokenizer = new NormalTokenizer();
        }

        protected override int ParseImpl(int i, ParseToken[] tokens, BasicTree tree, ObjectInfo objectInfo, ParseEventArgs e)
        {
            Host.InvokeInMainForm(() =>
            {
                Host.ClearError(e.Filename);
            });
            List<ParseResult> results = new List<ParseResult>();
            for (int j = 0; j < tokens.Length; j++)
            {
                var token = tokens[j];
                switch (token.TokenType)
                {
                    case TokenType.LetterOrDigit:
                        if (!hunspell.Spell(token.Token))
                        {
                            results.Add(new ParseResult(token));
                        }
                        break;
                    default:
                        break;
                }
            }

            Parallel.ForEach(results, result =>
            {
                result.CheckSuggests(hunspell);
            });
            Host.InvokeInMainForm(() =>
            {
                foreach (ParseResult result in results)
                {
                    var text = "";
                    if (result.Suggests.Length > 0)
                    {
                        text = String.Format("Missspell {0} (maybe {1})", result.Token.Token, String.Join(" or ", result.Suggests));
                    }
                    else
                    {
                        text = String.Format("Missspell {0}", result.Token.Token);
                    }
                    Host.AddError(ErrorType.Error, text, result.Token.Index, e.Filename);
                }
            });
            return tokens.Length;
        }

        class ParseResult
        {
            public ParseToken Token
            {
                get;
                private set;
            }

            public string[] Suggests
            {
                get;
                private set;
            }

            public ParseResult(ParseToken token)
            {
                Token = token;
            }

            public void CheckSuggests(Hunspell hunspell)
            {
                Suggests = hunspell.Suggest(Token.Token).ToArray();
            }
        }
    }
}
