﻿using System;
using System.Collections.Generic;
using System.Text;
using NotepadNeueExtension;

namespace ParseExtension
{
    class WordParser : IParser
    {
        #region IParser メンバ

        List<string> pool;

        public WordParser()
        {
            pool = new List<string>();
        }

        public void Parse(NotepadNeueExtension.ParseEventArgs e)
        {
            pool.Clear();
            string text = e.ParseText;
            int pos = 0;
            foreach (string word in text.Split(' ', '\r', '\n', '\t', '!', '"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', ';', ':', '<', '=', '>', '?', '@', '[', '\\', ']', '^', '`', '{', '|', '}', '~'))
            {
                string trimWord = word.Trim();
                if (trimWord != "" && !pool.Contains(trimWord))
                {
                    pool.Add(trimWord);
                    e.AssistData.GlobalVariable.Add(new VariableInfo()
                    {
                        Text = trimWord,
                        Name = trimWord,
                        HintText = "",
                        Type = "",
                        Summary = "",
                        DefineLocation = new DefineLocation()
                        {
                            DefineIndex = pos
                        }
                    });
                }
                pos += 1 + word.Length;
            }
        }

        #endregion
    }
}
