<?php

/*
 * Nucleus: PHP/MySQL Weblog CMS (http://nucleuscms.org/)
 * Copyright (C) 2002-2009 The Nucleus Group
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * (see nucleus/documentation/index.html#license for more info)
 */

/**
 * Nucleus RSS syndication channel skin
 * @license http://nucleuscms.org/license.txt GNU General Public License
 * @copyright Copyright (C) 2002-2009 The Nucleus Group
 * @version $Id: xml-rss2.php 1721 2012-03-31 10:18:25Z sakamocchi $
 */

header('Pragma: no-cache');

$CONF = array();
include('./config.php');

if ( !$CONF['DisableSite'] )
{
	// get feed into $feed
	ob_start();
	selectSkin('feeds/rss20');
	selector();
	$feed = ob_get_contents();
	ob_end_clean();
	
	/*
	 * create ETAG (hash of feed)
	 * (HTTP_IF_NONE_MATCH has quotes around it)
	 */
	$eTag = '"' . md5($feed) . '"';
	header('Etag: ' . $eTag);
	
	// compare Etag to what we got
	if ( $eTag == serverVar('HTTP_IF_NONE_MATCH') )
	{
		header('HTTP/1.0 304 Not Modified');
		header('Content-Length: 0');
	}
	else
	{
		echo $feed;
	}
}
// site is disabled, output empty RSS file
else
{
	echo '<?xml version="1.0" encoding="' . i18n::get_current_charset() . '"?>' . "\n";
	echo "<rss version=\"2.0\">\n";
	echo "<channel>\n";
	echo '<title>' . Entity::hsc($CONF['SiteName']) . "</title>\n";
	echo "<link>" . Entity::hsc($CONF['IndexURL']) . "</link>\n";
	echo "<description></description>\n";
	echo "<docs>http://backend.userland.com/rss</docs>\n";
	echo "</channel>\n";
	echo "</rss>\n";
}
