/* 
* PROJECT: NyARToolkitCPP
* --------------------------------------------------------------------------------
*
* The NyARToolkitCS is C++ version NyARToolkit class library.
* 
* Copyright (C)2008 R.Iizuka
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or (at your option) any later version.
* 
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* 
* You should have received a copy of the GNU General Public License
* along with this framework; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
* 
* For further information please contact.
*	http://nyatla.jp/nyatoolkit/
*	<airmail(at)ebony.plala.or.jp>
* 
*/
#include "NyARTransportVectorSolver.h"
#include "nyarcore.h"
namespace NyARToolkitCPP
{
	NyARTransportVectorSolver::NyARTransportVectorSolver(const NyARPerspectiveProjectionMatrix* i_projection_mat_ref,int i_max_vertex)
	{
		this->_projection_mat=i_projection_mat_ref;
		this->_cx=new double[i_max_vertex];
		this->_cy=new double[i_max_vertex];	
		return;
	}
	NyARTransportVectorSolver::~NyARTransportVectorSolver()
	{
		NyAR_SAFE_DELETE(this->_cx);
		NyAR_SAFE_DELETE(this->_cy);
		return;
	}

	void NyARTransportVectorSolver::set2dVertex(const TNyARDoublePoint2d* i_ref_vertex_2d,int i_number_of_vertex)
	{
		//3x2n2n*3̍s񂩂Aŏ@vZ邽߂3x3}gNXB		
		//[A]*[A]T
		//s[A]3ڂ̃LbV
		double* cx=this->_cx;
		double* cy=this->_cy;

		double m22;
		double p00=this->_projection_mat->m00;
		double p01=this->_projection_mat->m01;
		double p11=this->_projection_mat->m11;
		double p12=this->_projection_mat->m12;
		double p02=this->_projection_mat->m02;
		double w1,w2,w3,w4;
		this->_a00=i_number_of_vertex*p00*p00;
		this->_a01=i_number_of_vertex*p00*p01;
		this->_a10=i_number_of_vertex*p00*p01;
		this->_a11=i_number_of_vertex*(p01*p01+p11*p11);

		m22=0;
		w1=w2=0;
		for(int i=0;i<i_number_of_vertex;i++){
			//WۑĂB
			w3=p02-(cx[i]=i_ref_vertex_2d[i].x);
			w4=p12-(cy[i]=i_ref_vertex_2d[i].y);
			w1+=w3;
			w2+=w4;
			m22+=w3*w3+w4*w4;
		}
		this->_a02_20=w1*p00;
		this->_a12_21=p01*w1+p11*w2;
		this->_a22=m22;

		this->_nmber_of_vertex=i_number_of_vertex;
		return;
	}
	void NyARTransportVectorSolver::solveTransportVector(const TNyARDoublePoint3d i_vertex3d[],TNyARDoublePoint3d& o_transfer)const
	{
		int number_of_vertex=this->_nmber_of_vertex;
		double p00=this->_projection_mat->m00;
		double p01=this->_projection_mat->m01;
		double p02=this->_projection_mat->m02;
		double p11=this->_projection_mat->m11;
		double p12=this->_projection_mat->m12;
		//s[A]3ڂ̃LbV
		double* cx=this->_cx;
		double* cy=this->_cy;			

		//]sW̒_QɓK
		//[A]T*[b]vZ
		double bt1=0,bt2=0,bt3=0;
		for(int i=0;i<number_of_vertex;i++)
		{
			double w1=i_vertex3d[i].z*cx[i]-p00*i_vertex3d[i].x-p01*i_vertex3d[i].y-p02*i_vertex3d[i].z;
			double w2=i_vertex3d[i].z*cy[i]-p11*i_vertex3d[i].y-p12*i_vertex3d[i].z;
			bt1+=w1;
			bt2+=w2;
			bt3+=-cx[i]*w1-cy[i]*w2;
		}
		//([A]*T[A])*[T]=[A]T*[b]ŉB
		//a01a100Ɖ肵Ăǂ񂶂ȂȁH
		double b00=bt1*p00;
		double m00=this->_a00;
		double m10=this->_a10;
		double m20=this->_a02_20;
		double m12_21=this->_a12_21;
		double m01=this->_a01;

		double a=(this->_a11*m00-m10*m01);	
		double b=(m00*m12_21-m20*m01);	
		double c=(m00*this->_a22-m20*m20);	
		double d=(m00*(bt1*p02+bt2*p12+bt3)-m20*b00);	

		double z,y;
		o_transfer.z=z=((a*d)-(b*(m00*(b00+bt2*p11)-m10*b00)))/((c*a)-(b*(m00*m12_21-m10)));
		o_transfer.y=y=(d-c*z)/(b);
		o_transfer.x=(b00-m01*y-m20*z)/m00;
		return;
	}
}