/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core;

import jp.nyatla.nyartoolkit.NyARException;
import jp.nyatla.nyartoolkit.core.NyARParam;
import jp.nyatla.nyartoolkit.core.NyARSquare;
import jp.nyatla.nyartoolkit.core.NyARTransRot_OptimizeCommon;

class NyARTransRot_O3
extends NyARTransRot_OptimizeCommon {
    private final double[][] wk_initRot_wdir = new double[3][3];
    private final double[][] wk_arModifyMatrix_double1D = new double[8][3];

    public NyARTransRot_O3(NyARParam i_param, int i_number_of_vertex) throws NyARException {
        super(i_param, i_number_of_vertex);
        if (i_number_of_vertex != 4) {
            throw new NyARException();
        }
    }

    @Override
    public void initRot(NyARSquare marker_info, int i_direction) throws NyARException {
        double w;
        double[] cpara = this.cparam.get34Array();
        double[][] wdir = this.wk_initRot_wdir;
        int dir = i_direction;
        for (int j = 0; j < 2; ++j) {
            double w1 = marker_info.line[(4 - dir + j) % 4][0] * marker_info.line[(6 - dir + j) % 4][1] - marker_info.line[(6 - dir + j) % 4][0] * marker_info.line[(4 - dir + j) % 4][1];
            double w2 = marker_info.line[(4 - dir + j) % 4][1] * marker_info.line[(6 - dir + j) % 4][2] - marker_info.line[(6 - dir + j) % 4][1] * marker_info.line[(4 - dir + j) % 4][2];
            double w3 = marker_info.line[(4 - dir + j) % 4][2] * marker_info.line[(6 - dir + j) % 4][0] - marker_info.line[(6 - dir + j) % 4][2] * marker_info.line[(4 - dir + j) % 4][0];
            wdir[j][0] = w1 * (cpara[1] * cpara[6] - cpara[2] * cpara[5]) + w2 * cpara[5] - w3 * cpara[1];
            wdir[j][1] = -w1 * cpara[0] * cpara[6] + w3 * cpara[0];
            wdir[j][2] = w1 * cpara[0] * cpara[5];
            w = Math.sqrt(wdir[j][0] * wdir[j][0] + wdir[j][1] * wdir[j][1] + wdir[j][2] * wdir[j][2]);
            double[] dArray = wdir[j];
            dArray[0] = dArray[0] / w;
            double[] dArray2 = wdir[j];
            dArray2[1] = dArray2[1] / w;
            double[] dArray3 = wdir[j];
            dArray3[2] = dArray3[2] / w;
        }
        this.check_dir(wdir[0], marker_info.sqvertex[(4 - dir) % 4], marker_info.sqvertex[(5 - dir) % 4], cpara);
        this.check_dir(wdir[1], marker_info.sqvertex[(7 - dir) % 4], marker_info.sqvertex[(4 - dir) % 4], cpara);
        NyARTransRot_O3.check_rotation(wdir);
        wdir[2][0] = wdir[0][1] * wdir[1][2] - wdir[0][2] * wdir[1][1];
        wdir[2][1] = wdir[0][2] * wdir[1][0] - wdir[0][0] * wdir[1][2];
        wdir[2][2] = wdir[0][0] * wdir[1][1] - wdir[0][1] * wdir[1][0];
        w = Math.sqrt(wdir[2][0] * wdir[2][0] + wdir[2][1] * wdir[2][1] + wdir[2][2] * wdir[2][2]);
        double[] dArray = wdir[2];
        dArray[0] = dArray[0] / w;
        double[] dArray4 = wdir[2];
        dArray4[1] = dArray4[1] / w;
        double[] dArray5 = wdir[2];
        dArray5[2] = dArray5[2] / w;
        double[] rot = this.array;
        rot[0] = wdir[0][0];
        rot[3] = wdir[0][1];
        rot[6] = wdir[0][2];
        rot[1] = wdir[1][0];
        rot[4] = wdir[1][1];
        rot[7] = wdir[1][2];
        rot[2] = wdir[2][0];
        rot[5] = wdir[2][1];
        rot[8] = wdir[2][2];
    }

    @Override
    public double modifyMatrix(double[] trans, double[][] vertex, double[][] pos2d) throws NyARException {
        double ma = 0.0;
        double mb = 0.0;
        double mc = 0.0;
        double minerr = 0.0;
        int s1 = 0;
        int s2 = 0;
        int s3 = 0;
        double factor = 0.17453292519943295;
        double[] d_pt = vertex[0];
        double VX00 = d_pt[0];
        double VX01 = d_pt[1];
        double VX02 = d_pt[2];
        d_pt = vertex[1];
        double VX10 = d_pt[0];
        double VX11 = d_pt[1];
        double VX12 = d_pt[2];
        d_pt = vertex[2];
        double VX20 = d_pt[0];
        double VX21 = d_pt[1];
        double VX22 = d_pt[2];
        d_pt = vertex[3];
        double VX30 = d_pt[0];
        double VX31 = d_pt[1];
        double VX32 = d_pt[2];
        d_pt = pos2d[0];
        double P2D00 = d_pt[0];
        double P2D01 = d_pt[1];
        d_pt = pos2d[1];
        double P2D10 = d_pt[0];
        double P2D11 = d_pt[1];
        d_pt = pos2d[2];
        double P2D20 = d_pt[0];
        double P2D21 = d_pt[1];
        d_pt = pos2d[3];
        double P2D30 = d_pt[0];
        double P2D31 = d_pt[1];
        double[] cpara = this.cparam.get34Array();
        double CP0 = cpara[0];
        double CP1 = cpara[1];
        double CP2 = cpara[2];
        double CP3 = cpara[3];
        double CP4 = cpara[4];
        double CP5 = cpara[5];
        double CP6 = cpara[6];
        double CP7 = cpara[7];
        double CP8 = cpara[8];
        double CP9 = cpara[9];
        double CP10 = cpara[10];
        double combo03 = CP0 * trans[0] + CP1 * trans[1] + CP2 * trans[2] + CP3;
        double combo13 = CP4 * trans[0] + CP5 * trans[1] + CP6 * trans[2] + CP7;
        double combo23 = CP8 * trans[0] + CP9 * trans[1] + CP10 * trans[2] + cpara[11];
        double[][] double1D = this.wk_arModifyMatrix_double1D;
        double[] abc = double1D[0];
        double[] a_factor = double1D[1];
        double[] sinb = double1D[2];
        double[] cosb = double1D[3];
        double[] b_factor = double1D[4];
        double[] sinc = double1D[5];
        double[] cosc = double1D[6];
        double[] c_factor = double1D[7];
        this.arGetAngle(abc);
        double a2 = abc[0];
        double b2 = abc[1];
        double c2 = abc[2];
        for (int i = 0; i < 10; ++i) {
            minerr = 1.0E9;
            for (int j = 0; j < 3; ++j) {
                double w;
                double w2 = factor * (double)(j - 1);
                a_factor[j] = w = a2 + w2;
                b_factor[j] = w = b2 + w2;
                sinb[j] = Math.sin(w);
                cosb[j] = Math.cos(w);
                c_factor[j] = w = c2 + w2;
                sinc[j] = Math.sin(w);
                cosc[j] = Math.cos(w);
            }
            for (int t1 = 0; t1 < 3; ++t1) {
                double SA = Math.sin(a_factor[t1]);
                double CA = Math.cos(a_factor[t1]);
                double CACA = CA * CA;
                double SASA = SA * SA;
                double SACA = SA * CA;
                for (int t2 = 0; t2 < 3; ++t2) {
                    double wsin = sinb[t2];
                    double wcos = cosb[t2];
                    double CACACB = CACA * wcos;
                    double SACACB = SACA * wcos;
                    double SASACB = SASA * wcos;
                    double CASB = CA * wsin;
                    double SASB = SA * wsin;
                    double combo02 = CP0 * CASB + CP1 * SASB + CP2 * wcos;
                    double combo12 = CP4 * CASB + CP5 * SASB + CP6 * wcos;
                    double combo22 = CP8 * CASB + CP9 * SASB + CP10 * wcos;
                    double combo02_2 = combo02 * VX02 + combo03;
                    double combo02_5 = combo02 * VX12 + combo03;
                    double combo02_8 = combo02 * VX22 + combo03;
                    double combo02_11 = combo02 * VX32 + combo03;
                    double combo12_2 = combo12 * VX02 + combo13;
                    double combo12_5 = combo12 * VX12 + combo13;
                    double combo12_8 = combo12 * VX22 + combo13;
                    double combo12_11 = combo12 * VX32 + combo13;
                    double combo22_2 = combo22 * VX02 + combo23;
                    double combo22_5 = combo22 * VX12 + combo23;
                    double combo22_8 = combo22 * VX22 + combo23;
                    double combo22_11 = combo22 * VX32 + combo23;
                    for (int t3 = 0; t3 < 3; ++t3) {
                        wsin = sinc[t3];
                        wcos = cosc[t3];
                        double SACASC = SACA * wsin;
                        double SACACC = SACA * wcos;
                        double SACACBSC = SACACB * wsin;
                        double SACACBCC = SACACB * wcos;
                        double rot0 = CACACB * wcos + SASA * wcos + SACACBSC - SACASC;
                        double rot3 = SACACBCC - SACACC + SASACB * wsin + CACA * wsin;
                        double rot6 = -CASB * wcos - SASB * wsin;
                        double combo00 = CP0 * rot0 + CP1 * rot3 + CP2 * rot6;
                        double combo10 = CP4 * rot0 + CP5 * rot3 + CP6 * rot6;
                        double combo20 = CP8 * rot0 + CP9 * rot3 + CP10 * rot6;
                        double rot1 = -CACACB * wsin - SASA * wsin + SACACBCC - SACACC;
                        double rot4 = -SACACBSC + SACASC + SASACB * wcos + CACA * wcos;
                        double rot7 = CASB * wsin - SASB * wcos;
                        double combo01 = CP0 * rot1 + CP1 * rot4 + CP2 * rot7;
                        double combo11 = CP4 * rot1 + CP5 * rot4 + CP6 * rot7;
                        double combo21 = CP8 * rot1 + CP9 * rot4 + CP10 * rot7;
                        double err = 0.0;
                        double h = combo20 * VX00 + combo21 * VX01 + combo22_2;
                        double x = P2D00 - (combo00 * VX00 + combo01 * VX01 + combo02_2) / h;
                        double y = P2D01 - (combo10 * VX00 + combo11 * VX01 + combo12_2) / h;
                        err += x * x + y * y;
                        h = combo20 * VX10 + combo21 * VX11 + combo22_5;
                        x = P2D10 - (combo00 * VX10 + combo01 * VX11 + combo02_5) / h;
                        y = P2D11 - (combo10 * VX10 + combo11 * VX11 + combo12_5) / h;
                        err += x * x + y * y;
                        h = combo20 * VX20 + combo21 * VX21 + combo22_8;
                        x = P2D20 - (combo00 * VX20 + combo01 * VX21 + combo02_8) / h;
                        y = P2D21 - (combo10 * VX20 + combo11 * VX21 + combo12_8) / h;
                        err += x * x + y * y;
                        h = combo20 * VX30 + combo21 * VX31 + combo22_11;
                        x = P2D30 - (combo00 * VX30 + combo01 * VX31 + combo02_11) / h;
                        y = P2D31 - (combo10 * VX30 + combo11 * VX31 + combo12_11) / h;
                        if (!((err += x * x + y * y) < minerr)) continue;
                        minerr = err;
                        ma = a_factor[t1];
                        mb = b_factor[t2];
                        mc = c_factor[t3];
                        s1 = t1 - 1;
                        s2 = t2 - 1;
                        s3 = t3 - 1;
                    }
                }
            }
            if (s1 == 0 && s2 == 0 && s3 == 0) {
                factor *= 0.5;
            }
            a2 = ma;
            b2 = mb;
            c2 = mc;
        }
        NyARTransRot_O3.arGetRot(ma, mb, mc, this.array);
        return minerr / 4.0;
    }
}

