/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core.pixeldriver;

import jp.nyatla.nyartoolkit.core.NyARException;
import jp.nyatla.nyartoolkit.core.pixeldriver.INyARGsPixelDriver;
import jp.nyatla.nyartoolkit.core.raster.INyARRaster;
import jp.nyatla.nyartoolkit.core.types.NyARIntSize;

class NyARGsPixelDriver_INT1D_GRAY_8
implements INyARGsPixelDriver {
    protected int[] _ref_buf;
    private NyARIntSize _ref_size;

    NyARGsPixelDriver_INT1D_GRAY_8() {
    }

    @Override
    public NyARIntSize getSize() {
        return this._ref_size;
    }

    @Override
    public void getPixelSet(int[] i_x, int[] i_y, int i_n, int[] o_buf, int i_st_buf) {
        int w = this._ref_size.w;
        int[] b = this._ref_buf;
        int i = i_n - 1;
        while (i >= 0) {
            int bp = i_x[i] + i_y[i] * w;
            o_buf[i_st_buf + i] = b[bp];
            --i;
        }
    }

    @Override
    public int getPixel(int i_x, int i_y) {
        int[] ref_buf = this._ref_buf;
        return ref_buf[i_x + i_y * this._ref_size.w];
    }

    @Override
    public void setPixel(int i_x, int i_y, int i_gs) throws NyARException {
        this._ref_buf[i_x + i_y * this._ref_size.w] = i_gs;
    }

    @Override
    public void setPixels(int[] i_x, int[] i_y, int i_num, int[] i_intgs) throws NyARException {
        int w = this._ref_size.w;
        int[] r = this._ref_buf;
        int i = i_num - 1;
        while (i >= 0) {
            r[i_x[i] + i_y[i] * w] = i_intgs[i];
            --i;
        }
    }

    @Override
    public void switchRaster(INyARRaster i_ref_raster) throws NyARException {
        this._ref_buf = (int[])i_ref_raster.getBuffer();
        this._ref_size = i_ref_raster.getSize();
    }

    @Override
    public boolean isCompatibleRaster(INyARRaster i_raster) {
        return i_raster.isEqualBufferType(262145);
    }
}

