/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core.rasterdriver;

import jp.nyatla.nyartoolkit.core.NyARException;
import jp.nyatla.nyartoolkit.core.raster.INyARGrayscaleRaster;
import jp.nyatla.nyartoolkit.core.raster.rgb.INyARRgbRaster;
import jp.nyatla.nyartoolkit.core.rasterdriver.INyARHistogramFromRaster;
import jp.nyatla.nyartoolkit.core.rasterdriver.NyARHistogramFromRaster_AnyGs;
import jp.nyatla.nyartoolkit.core.rasterdriver.NyARHistogramFromRaster_AnyRgb;
import jp.nyatla.nyartoolkit.core.rasterdriver.NyARHistogramFromRaster_INTGS8;

public class NyARHistogramFromRasterFactory {
    public static INyARHistogramFromRaster createInstance(INyARGrayscaleRaster i_raster) throws NyARException {
        switch (i_raster.getBufferType()) {
            case 262145: 
            case 262146: {
                return new NyARHistogramFromRaster_INTGS8(i_raster);
            }
        }
        if (i_raster instanceof INyARGrayscaleRaster) {
            return new NyARHistogramFromRaster_AnyGs(i_raster);
        }
        if (i_raster instanceof INyARRgbRaster) {
            return new NyARHistogramFromRaster_AnyRgb((INyARRgbRaster)((Object)i_raster));
        }
        throw new NyARException();
    }

    public static INyARHistogramFromRaster createInstance(INyARRgbRaster i_raster) throws NyARException {
        if (i_raster instanceof INyARRgbRaster) {
            return new NyARHistogramFromRaster_AnyRgb(i_raster);
        }
        throw new NyARException();
    }
}

