/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core.squaredetect;

import jp.nyatla.nyartoolkit.NyARException;
import jp.nyatla.nyartoolkit.core.labeling.artoolkit.NyARLabelingImage;
import jp.nyatla.nyartoolkit.core.raster.INyARRaster;
import jp.nyatla.nyartoolkit.core.raster.NyARBinRaster;
import jp.nyatla.nyartoolkit.core.raster.NyARGrayscaleRaster;

public class NyARContourPickup {
    protected static final int[] _getContour_xdir;
    protected static final int[] _getContour_ydir;

    static {
        int[] nArray = new int[15];
        nArray[1] = 1;
        nArray[2] = 1;
        nArray[3] = 1;
        nArray[5] = -1;
        nArray[6] = -1;
        nArray[7] = -1;
        nArray[9] = 1;
        nArray[10] = 1;
        nArray[11] = 1;
        nArray[13] = -1;
        nArray[14] = -1;
        _getContour_xdir = nArray;
        int[] nArray2 = new int[15];
        nArray2[0] = -1;
        nArray2[1] = -1;
        nArray2[3] = 1;
        nArray2[4] = 1;
        nArray2[5] = 1;
        nArray2[7] = -1;
        nArray2[8] = -1;
        nArray2[9] = -1;
        nArray2[11] = 1;
        nArray2[12] = 1;
        nArray2[13] = 1;
        _getContour_ydir = nArray2;
    }

    public int getContour(NyARBinRaster i_raster, int i_entry_x, int i_entry_y, int i_array_size, int[] o_coord_x, int[] o_coord_y) throws NyARException {
        assert (i_raster.isEqualBufferType(262146));
        return this.impl_getContour(i_raster, 0, i_entry_x, i_entry_y, i_array_size, o_coord_x, o_coord_y);
    }

    public int getContour(NyARGrayscaleRaster i_raster, int i_th, int i_entry_x, int i_entry_y, int i_array_size, int[] o_coord_x, int[] o_coord_y) throws NyARException {
        assert (i_raster.isEqualBufferType(262145));
        return this.impl_getContour(i_raster, i_th, i_entry_x, i_entry_y, i_array_size, o_coord_x, o_coord_y);
    }

    private int impl_getContour(INyARRaster i_raster, int i_th, int i_entry_x, int i_entry_y, int i_array_size, int[] o_coord_x, int[] o_coord_y) throws NyARException {
        int coord_num;
        block6: {
            int[] xdir = _getContour_xdir;
            int[] ydir = _getContour_ydir;
            int[] i_buf = (int[])i_raster.getBuffer();
            int width = i_raster.getWidth();
            int height = i_raster.getHeight();
            coord_num = 1;
            o_coord_x[0] = i_entry_x;
            o_coord_y[0] = i_entry_y;
            int dir = 5;
            int c = i_entry_x;
            int r = i_entry_y;
            do {
                dir = (dir + 5) % 8;
                if (c >= 1 && c < width - 1 && r >= 1 && r < height - 1) {
                    if (i_buf[(r + ydir[dir]) * width + (c + xdir[dir])] > i_th && i_buf[(r + ydir[++dir]) * width + (c + xdir[dir])] > i_th && i_buf[(r + ydir[++dir]) * width + (c + xdir[dir])] > i_th && i_buf[(r + ydir[++dir]) * width + (c + xdir[dir])] > i_th && i_buf[(r + ydir[++dir]) * width + (c + xdir[dir])] > i_th && i_buf[(r + ydir[++dir]) * width + (c + xdir[dir])] > i_th && i_buf[(r + ydir[++dir]) * width + (c + xdir[dir])] > i_th && i_buf[(r + ydir[++dir]) * width + (c + xdir[dir])] > i_th) {
                        throw new NyARException();
                    }
                } else {
                    int i = 0;
                    while (i < 8) {
                        int x = c + xdir[dir];
                        int y = r + ydir[dir];
                        if (x >= 0 && x < width && y >= 0 && y < height && i_buf[y * width + x] <= i_th) break;
                        ++dir;
                        ++i;
                    }
                    if (i == 8) {
                        throw new NyARException();
                    }
                }
                o_coord_x[coord_num] = c += xdir[dir %= 8];
                o_coord_y[coord_num] = r += ydir[dir];
                if (c == i_entry_x && r == i_entry_y) break block6;
            } while (++coord_num != i_array_size);
            return coord_num;
        }
        return ++coord_num;
    }

    public int getContour(NyARLabelingImage i_raster, int i_entry_x, int i_entry_y, int i_array_size, int[] o_coord_x, int[] o_coord_y) throws NyARException {
        int coord_num;
        block6: {
            int[] xdir = _getContour_xdir;
            int[] ydir = _getContour_ydir;
            int[] i_buf = (int[])i_raster.getBuffer();
            int width = i_raster.getWidth();
            int height = i_raster.getHeight();
            int sx = i_entry_x;
            int sy = i_entry_y;
            coord_num = 1;
            o_coord_x[0] = sx;
            o_coord_y[0] = sy;
            int dir = 5;
            int c = o_coord_x[0];
            int r = o_coord_y[0];
            do {
                dir = (dir + 5) % 8;
                if (c >= 1 && c < width - 1 && r >= 1 && r < height - 1) {
                    if (i_buf[(r + ydir[dir]) * width + (c + xdir[dir])] <= 0 && i_buf[(r + ydir[++dir]) * width + (c + xdir[dir])] <= 0 && i_buf[(r + ydir[++dir]) * width + (c + xdir[dir])] <= 0 && i_buf[(r + ydir[++dir]) * width + (c + xdir[dir])] <= 0 && i_buf[(r + ydir[++dir]) * width + (c + xdir[dir])] <= 0 && i_buf[(r + ydir[++dir]) * width + (c + xdir[dir])] <= 0 && i_buf[(r + ydir[++dir]) * width + (c + xdir[dir])] <= 0 && i_buf[(r + ydir[++dir]) * width + (c + xdir[dir])] <= 0) {
                        throw new NyARException();
                    }
                } else {
                    int i = 0;
                    while (i < 8) {
                        int x = c + xdir[dir];
                        int y = r + ydir[dir];
                        if (x >= 0 && x < width && y >= 0 && y < height && i_buf[y * width + x] > 0) break;
                        ++dir;
                        ++i;
                    }
                    if (i == 8) {
                        throw new NyARException();
                    }
                }
                o_coord_x[coord_num] = c += xdir[dir %= 8];
                o_coord_y[coord_num] = r += ydir[dir];
                if (c == sx && r == sy) break block6;
            } while (++coord_num != i_array_size);
            return coord_num;
        }
        return ++coord_num;
    }
}

