/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core.analyzer.histogram;

import jp.nyatla.nyartoolkit.core.analyzer.histogram.INyARHistogramAnalyzer_Threshold;
import jp.nyatla.nyartoolkit.core.types.NyARHistogram;

public class NyARHistogramAnalyzer_KittlerThreshold
implements INyARHistogramAnalyzer_Threshold {
    public int getThreshold(NyARHistogram i_histogram) {
        double min = Double.MAX_VALUE;
        int th = 0;
        int[] hist = i_histogram.data;
        int n = i_histogram.length;
        int pa = 0;
        int da = 0;
        int i = 0;
        while (i < n) {
            int h = hist[i];
            da += h * i;
            pa += h * i * i;
            ++i;
        }
        int sa = i_histogram.total_of_data;
        int db = 0;
        int sb = 0;
        int pb = 0;
        i = n - 1;
        while (i > 0) {
            int hist_count = hist[i];
            int hist_val = hist_count * i;
            int hist_val2 = hist_val * i;
            da -= hist_val;
            pa -= hist_val2;
            db += hist_val;
            pb += hist_val2;
            double wa = (double)(sa -= hist_count) / (double)(sa + (sb += hist_count));
            double wb = (double)sb / (double)(sa + sb);
            if (wa != 0.0 && wb != 0.0) {
                double ob = 0.0;
                double oa = 0.0;
                double ma = sa != 0 ? (double)da / (double)sa : 0.0;
                oa = ((double)pa + ma * ma * (double)sa - 2.0 * ma * (double)da) / (double)sa;
                double mb = sb != 0 ? (double)db / (double)sb : 0.0;
                ob = ((double)pb + mb * mb * (double)sb - 2.0 * mb * (double)db) / (double)sb;
                double kai = wa * Math.log(oa / wa) + wb * Math.log(ob / wb);
                if (kai > 0.0 && min > kai) {
                    min = kai;
                    th = i;
                }
            }
            --i;
        }
        return th;
    }

    public static void main(String[] args) {
        NyARHistogram data = new NyARHistogram(256);
        int i = 0;
        while (i < 256) {
            data.data[i] = 128 - i > 0 ? 128 - i : i - 128;
            ++i;
        }
        data.total_of_data = data.getTotal(0, 255);
        NyARHistogramAnalyzer_KittlerThreshold an = new NyARHistogramAnalyzer_KittlerThreshold();
        int th = an.getThreshold(data);
        System.out.print(th);
    }
}

