/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core.types;

import jp.nyatla.nyartoolkit.core.types.NyARDoublePoint2d;
import jp.nyatla.nyartoolkit.core.types.NyARLinear;

public class NyARVecLinear2d {
    public double x;
    public double y;
    public double dx;
    public double dy;

    public static NyARVecLinear2d[] createArray(int i_length) {
        NyARVecLinear2d[] r = new NyARVecLinear2d[i_length];
        int i = 0;
        while (i < i_length) {
            r[i] = new NyARVecLinear2d();
            ++i;
        }
        return r;
    }

    public final void normalVec(NyARVecLinear2d i_src) {
        double w = this.dx;
        this.dx = i_src.dy;
        this.dy = -w;
    }

    public final void setValue(NyARVecLinear2d i_value) {
        this.dx = i_value.dx;
        this.dy = i_value.dy;
        this.x = i_value.x;
        this.y = i_value.y;
    }

    public final double getVecCos(NyARVecLinear2d i_v1) {
        double x1 = i_v1.dx;
        double y1 = i_v1.dy;
        double x2 = this.dx;
        double y2 = this.dy;
        double d = (x1 * x2 + y1 * y2) / Math.sqrt((x1 * x1 + y1 * y1) * (x2 * x2 + y2 * y2));
        return d;
    }

    public final double getAbsVecCos(NyARVecLinear2d i_v1) {
        double d = this.getVecCos(i_v1);
        return d >= 0.0 ? d : -d;
    }

    public final double getVecCos(double i_dx, double i_dy) {
        double x1 = this.dx;
        double y1 = this.dy;
        return (x1 * i_dx + y1 * i_dy) / Math.sqrt((x1 * x1 + y1 * y1) * (i_dx * i_dx + i_dy * i_dy));
    }

    public final double getAbsVecCos(double i_v2_x, double i_v2_y) {
        double d = this.getVecCos(i_v2_x, i_v2_y);
        return d >= 0.0 ? d : -d;
    }

    public final double getVecCos(NyARDoublePoint2d i_pos1, NyARDoublePoint2d i_pos2) {
        return this.getVecCos(i_pos2.x - i_pos1.x, i_pos2.y - i_pos1.y);
    }

    public final double getAbsVecCos(NyARDoublePoint2d i_pos1, NyARDoublePoint2d i_pos2) {
        return this.getAbsVecCos(i_pos2.x - i_pos1.x, i_pos2.y - i_pos1.y);
    }

    public final boolean crossPos(NyARVecLinear2d i_vector1, NyARDoublePoint2d o_point) {
        double a1 = i_vector1.dy;
        double b1 = -i_vector1.dx;
        double c1 = i_vector1.dx * i_vector1.y - i_vector1.dy * i_vector1.x;
        double a2 = this.dy;
        double b2 = -this.dx;
        double c2 = this.dx * this.y - this.dy * this.x;
        double w1 = a1 * b2 - a2 * b1;
        if (w1 == 0.0) {
            return false;
        }
        o_point.x = (b1 * c2 - b2 * c1) / w1;
        o_point.y = (a2 * c1 - a1 * c2) / w1;
        return true;
    }

    public final double sqDistBySegmentLineEdge(NyARDoublePoint2d i_sp1, NyARDoublePoint2d i_sp2) {
        double sa = this.dy;
        double sb = -this.dx;
        double sc = this.dx * this.y - this.dy * this.x;
        double w1 = sa * -sa - sb * sb;
        if (w1 == 0.0) {
            return Double.POSITIVE_INFINITY;
        }
        double lc = -(sb * i_sp1.x - sa * i_sp1.y);
        double x = (sb * lc + sa * sc) / w1 - i_sp1.x;
        double y = (sb * sc - sa * lc) / w1 - i_sp1.y;
        double sqdist = x * x + y * y;
        lc = -(sb * i_sp2.x - sa * i_sp2.y);
        x = (sb * lc + sa * sc) / w1 - i_sp2.x;
        y = (sb * sc - sa * lc) / w1 - i_sp2.y;
        return sqdist + x * x + y * y;
    }

    public boolean setLinear(NyARLinear i_line, double i_x, double i_y) {
        double la = i_line.b;
        double lb = -i_line.a;
        double lc = -(la * i_x + lb * i_y);
        double w1 = -lb * lb - la * la;
        if (w1 == 0.0) {
            return false;
        }
        this.x = (la * lc - lb * i_line.c) / w1;
        this.y = (la * i_line.c + lb * lc) / w1;
        this.dy = -lb;
        this.dx = -la;
        return true;
    }

    public final boolean leastSquares(NyARDoublePoint2d[] i_points, int i_number_of_data) {
        double sum_xy = 0.0;
        double sum_x = 0.0;
        double sum_y = 0.0;
        double sum_x2 = 0.0;
        int i = 0;
        while (i < i_number_of_data) {
            NyARDoublePoint2d ptr = i_points[i];
            double xw = ptr.x;
            sum_xy += xw * ptr.y;
            sum_x += xw;
            sum_y += ptr.y;
            sum_x2 += xw * xw;
            ++i;
        }
        double la = -((double)i_number_of_data * sum_x2 - sum_x * sum_x);
        double lb = -((double)i_number_of_data * sum_xy - sum_x * sum_y);
        double cc = sum_x2 * sum_y - sum_xy * sum_x;
        double lc = -(la * sum_x + lb * sum_y) / (double)i_number_of_data;
        double w1 = -lb * lb - la * la;
        if (w1 == 0.0) {
            return false;
        }
        this.x = (la * lc - lb * cc) / w1;
        this.y = (la * cc + lb * lc) / w1;
        this.dy = -lb;
        this.dx = -la;
        return true;
    }

    public final boolean leastSquaresWithNormalize(NyARDoublePoint2d[] i_points, int i_number_of_data) {
        boolean ret = this.leastSquares(i_points, i_number_of_data);
        double sq = 1.0 / Math.sqrt(this.dx * this.dx + this.dy * this.dy);
        this.dx *= sq;
        this.dy *= sq;
        return ret;
    }
}

