/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyar4psg;

import jp.nyatla.nyar4psg.PImageRaster;
import jp.nyatla.nyar4psg.SingleMarkerBaseClass;
import jp.nyatla.nyartoolkit.NyARException;
import jp.nyatla.nyartoolkit.core.param.NyARParam;
import jp.nyatla.nyartoolkit.core.raster.rgb.INyARRgbRaster;
import jp.nyatla.nyartoolkit.core.squaredetect.NyARSquare;
import jp.nyatla.nyartoolkit.core.transmat.NyARTransMatResult;
import jp.nyatla.nyartoolkit.core.types.NyARDoublePoint3d;
import jp.nyatla.nyartoolkit.nyidmarker.data.INyIdMarkerData;
import jp.nyatla.nyartoolkit.nyidmarker.data.INyIdMarkerDataEncoder;
import jp.nyatla.nyartoolkit.nyidmarker.data.NyIdMarkerDataEncoder_RawBit;
import jp.nyatla.nyartoolkit.nyidmarker.data.NyIdMarkerData_RawBit;
import jp.nyatla.nyartoolkit.processor.SingleNyIdMarkerProcesser;
import processing.core.PApplet;
import processing.core.PImage;
import processing.core.PVector;

public class SingleNyIdMarker
extends SingleMarkerBaseClass {
    public static final int ST_NOMARKER = 0;
    public static final int ST_NEWMARKER = 1;
    public static final int ST_UPDATEMARKER = 2;
    public static final int ST_REMOVEMARKER = 3;
    public int markerid;
    private PImageRaster _raster;
    private MarkerProcessor _marker_proc;
    private boolean _registerd_marker = false;

    public SingleNyIdMarker(PApplet parent, int i_width, int i_height, String i_cparam, int i_projection_coord_system) {
        super(parent, i_cparam, i_width, i_height, i_projection_coord_system);
        try {
            this._raster = new PImageRaster(i_width, i_height);
        }
        catch (NyARException e) {
            this._pa.die("Error on SingleNyIdMarker", (Exception)((Object)e));
        }
    }

    public void setIdMarkerSize(double i_width) {
        if (this._registerd_marker) {
            this._pa.die("Error already called setIdMarkerSize.", (Exception)((Object)new NyARException()));
        }
        try {
            this._marker_proc = new MarkerProcessor(this._ar_param, this._raster.getBufferType());
        }
        catch (NyARException e) {
            this._pa.die("Error on setIdMarkerSize", (Exception)((Object)e));
        }
        this._registerd_marker = true;
    }

    public int detect(PImage i_image) {
        if (!this._registerd_marker) {
            this._pa.die("Must call setIdMarkerSize function in the first.");
        }
        try {
            this._raster.wrapBuffer(i_image);
            this._marker_proc.initSequence();
            this._marker_proc.detectMarker((INyARRgbRaster)this._raster);
            switch (this._marker_proc.status) {
                case 0: 
                case 3: {
                    this.transmat = null;
                    this.angle = null;
                    this.pos2d = null;
                    this.trans = null;
                    this.markerid = -1;
                    break;
                }
                case 1: {
                    this.transmat = this._marker_proc.gltransmat;
                    this.angle = this._marker_proc.angle;
                    this.pos2d = this._marker_proc.pos2d;
                    this.trans = this._marker_proc.trans;
                    this.markerid = this._marker_proc.current_id;
                    break;
                }
                case 2: {
                    break;
                }
                default: {
                    throw new NyARException();
                }
            }
        }
        catch (NyARException e) {
            this._pa.die("Error while marker detecting up NyARToolkit for java", (Exception)((Object)e));
        }
        return this._marker_proc.status;
    }

    private class MarkerProcessor
    extends SingleNyIdMarkerProcesser {
        public double[] gltransmat = new double[16];
        public PVector angle = new PVector();
        public int[][] pos2d = new int[4][2];
        public PVector trans = new PVector();
        public int current_id = -1;
        public int status;
        private final NyARDoublePoint3d _tmp_d3p = new NyARDoublePoint3d();
        private boolean _is_prev_onenter;

        public void initSequence() {
            this.status = this.status == 3 ? 0 : this.status;
        }

        public MarkerProcessor(NyARParam i_cparam, int i_raster_format) throws NyARException {
            this.initInstance(i_cparam, (INyIdMarkerDataEncoder)new NyIdMarkerDataEncoder_RawBit(), 100, i_raster_format);
        }

        protected void onLeaveHandler() {
            this.current_id = -1;
            this.status = 3;
        }

        protected void onUpdateHandler(NyARSquare i_square, NyARTransMatResult result) {
            SingleNyIdMarker.matResult2GLArray(result, this.gltransmat);
            result.getZXYAngle(this._tmp_d3p);
            this.angle.x = (float)this._tmp_d3p.x;
            this.angle.y = (float)this._tmp_d3p.y;
            this.angle.z = (float)this._tmp_d3p.z;
            this.trans.x = (float)result.m03;
            this.trans.y = (float)result.m13;
            this.trans.z = (float)result.m23;
            int i = 0;
            while (i < 4) {
                this.pos2d[i][0] = (int)i_square.sqvertex[i].x;
                this.pos2d[i][1] = (int)i_square.sqvertex[i].y;
                ++i;
            }
            this.status = this._is_prev_onenter ? 1 : 2;
            this._is_prev_onenter = false;
        }

        protected void onEnterHandler(INyIdMarkerData i_code) {
            NyIdMarkerData_RawBit code = (NyIdMarkerData_RawBit)i_code;
            if (code.length > 4) {
                this.current_id = -1;
            } else {
                this.current_id = 0;
                int i = 0;
                while (i < code.length) {
                    this.current_id = this.current_id << 8 | code.packet[i];
                    ++i;
                }
            }
            this.status = 1;
            this._is_prev_onenter = true;
        }
    }
}

