/* 
* PROJECT: NyARToolkitCPP
* --------------------------------------------------------------------------------
*
* The NyARToolkitCPP is C++ version NyARToolkit class library.
* Copyright (C)2008-2009 Ryo Iizuka
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
* 
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>.
* 
* For further information please contact.
*	http://nyatla.jp/nyatoolkit/
*	<airmail(at)ebony.plala.or.jp> or <nyatla(at)nyatla.jp>
* 
*/
#include "NyARBaseClass.h"
#include "NyARTransMat.h"
#include "NyARSquareStack.h"
#include "NyARParam.h"
#include "NyARBinRaster.h"
#include "INyIdMarkerDataEncoder.h"
#include "NyARRasterFilter_ARToolkitThreshold.h"
#include "NyIdMarkerPickup.h"
#include "NyIdMarkerPattern.h"
#include "NyIdMarkerParam.h"
#include "NyARRasterThresholdAnalyzer_SlidePTile.h"
#include "NyARSquareDetector_Rle.h"

namespace NyARToolkitCPP
{
	class SingleNyIdMarkerProcesser:public NyARBaseClass
	{
	public:
		void* tag;
	private:
		int _lost_delay_count;
		int _lost_delay;
	private:
		NyARSquareDetector_Rle* _square_detect;
		bool _initialized;
	protected:
		INyARTransMat* _transmat;
	private:
		double _marker_width;
	private:
		NyARSquareStack* _square_list;
		const INyIdMarkerDataEncoder* _encoder;
		bool _is_active;
		INyIdMarkerData* _data_temp;
		INyIdMarkerData* _data_current;

		int _current_threshold;
		// [AR]oʂ̕ۑp
		NyARBinRaster* _bin_raster;
		NyARRasterFilter_ARToolkitThreshold* _tobin_filter;
		NyIdMarkerPickup* _id_pickup;

		NyARRasterThresholdAnalyzer_SlidePTile* _threshold_detect;
	protected:
		//filter͎Ō߂
		SingleNyIdMarkerProcesser();
		virtual ~SingleNyIdMarkerProcesser();
		void initInstance(const NyARParam* i_param,const INyIdMarkerDataEncoder* i_encoder,int i_raster_format);
	public:
		void setMarkerWidth(int i_width);
		void reset(bool i_is_force);
		void detectMarker(const INyARRgbRaster &i_raster);
	private:	
		void detectNewMarker(const INyARRgbRaster& i_raster, NyARSquareStack& i_stack);
		void detectExistMarker(const INyARRgbRaster &i_raster, NyARSquareStack &i_stack);
		NyARTransMatResult __NyARSquare_result;
	private:
		bool updateStatus(const NyARSquare &i_square,const INyIdMarkerData* i_marker_data,const TNyIdMarkerParam &i_param);
	protected:
		virtual void onEnterHandler(const INyIdMarkerData& i_code)=0;
		virtual void onLeaveHandler()=0;
		virtual void onUpdateHandler(const NyARSquare& i_square,const NyARTransMatResult& result)=0;
	};
}
