package java3d;

import java.awt.Component;

import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;

import jp.ac.kyutech.ai.ylab.shiva.utils.nativecapable.NativeCapableModule;

import com.sun.j3d.utils.geometry.ColorCube;
import com.sun.j3d.utils.universe.SimpleUniverse;

public class Java3DTestModule implements NativeCapableModule {

	private Canvas3D c3d;

	@Override
	public boolean initModule() {

		c3d = new Canvas3D(SimpleUniverse.getPreferredConfiguration());
		SimpleUniverse univ = new SimpleUniverse(c3d);
		univ.getViewingPlatform().setNominalViewingTransform();

		BranchGroup bg = new BranchGroup();
		bg.addChild(new ColorCube(0.5));
		bg.compile();

		univ.addBranchGraph(bg);

		return true;
	}

	@Override
	public Component getRootComponent() {
		return c3d;
	}

	@Override
	public boolean startModule() {
		return true;
	}

	@Override
	public boolean destroyModule() {
		return true;
	}
}
