/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core.rasterreader;

import jp.nyatla.nyartoolkit.NyARException;
import jp.nyatla.nyartoolkit.core.rasterreader.INyARRgbPixelReader;
import jp.nyatla.nyartoolkit.core.types.NyARIntSize;

public class NyARRgbPixelReader_INT1D_GRAY_8
implements INyARRgbPixelReader {
    protected int[] _ref_buf;
    private NyARIntSize _size;

    public NyARRgbPixelReader_INT1D_GRAY_8(int[] i_buf, NyARIntSize i_size) {
        this._ref_buf = i_buf;
        this._size = i_size;
    }

    public void getPixel(int i_x, int i_y, int[] o_rgb) {
        o_rgb[1] = o_rgb[2] = this._ref_buf[i_x + i_y * this._size.w];
        o_rgb[0] = o_rgb[2];
    }

    public void getPixelSet(int[] i_x, int[] i_y, int i_num, int[] o_rgb) {
        int width = this._size.w;
        int[] ref_buf = this._ref_buf;
        int i = i_num - 1;
        while (i >= 0) {
            int n = ref_buf[i_x[i] + i_y[i] * width];
            o_rgb[i * 3 + 2] = n;
            o_rgb[i * 3 + 1] = n;
            o_rgb[i * 3 + 0] = n;
            --i;
        }
    }

    public void setPixel(int i_x, int i_y, int[] i_rgb) throws NyARException {
        NyARException.notImplement();
    }

    public void setPixels(int[] i_x, int[] i_y, int i_num, int[] i_intrgb) throws NyARException {
        NyARException.notImplement();
    }

    public void switchBuffer(Object i_ref_buffer) throws NyARException {
        assert (((int[])i_ref_buffer).length >= this._size.w * this._size.h);
        this._ref_buf = (int[])i_ref_buffer;
    }
}

