/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.rpf.tracker.nyartk;

import jp.nyatla.nyartoolkit.core.param.INyARCameraDistortionFactor;
import jp.nyatla.nyartoolkit.core.raster.NyARGrayscaleRaster;
import jp.nyatla.nyartoolkit.core.squaredetect.NyARContourPickup;
import jp.nyatla.nyartoolkit.core.types.NyARDoublePoint2d;
import jp.nyatla.nyartoolkit.core.types.NyARVecLinear2d;
import jp.nyatla.nyartoolkit.rpf.tracker.nyartk.NyARVectorReader_Base;

public class NyARVectorReader_INT1D_GRAY_8
extends NyARVectorReader_Base {
    private NyARDoublePoint2d __tmp = new NyARDoublePoint2d();

    public NyARVectorReader_INT1D_GRAY_8(NyARGrayscaleRaster i_ref_raster, INyARCameraDistortionFactor i_ref_raster_distortion, NyARGrayscaleRaster i_ref_rob_raster) {
        assert (i_ref_raster.getBufferType() == 262145);
        assert (i_ref_rob_raster.getBufferType() == 262145);
        this.initInstance(i_ref_raster, i_ref_raster_distortion, i_ref_rob_raster, new NyARContourPickup());
    }

    @Override
    public final int getAreaVector33(int ix, int iy, int iw, int ih, NyARVecLinear2d o_posvec) {
        double yy;
        double xx;
        assert (ih >= 3 && iw >= 3);
        assert (ix >= 0 && iy >= 0 && ix + iw <= this._ref_base_raster.getWidth() && iy + ih <= this._ref_base_raster.getHeight());
        int[] buf = (int[])this._ref_base_raster.getBuffer();
        int stride = this._ref_base_raster.getWidth();
        int sum_vy = 0;
        int sum_vx = 0;
        int sum_wy = 0;
        int sum_wx = 0;
        int sum_y = 0;
        int sum_x = 0;
        int lw = iw - 3;
        int i = ih - 3;
        while (i >= 0) {
            int idx_0 = stride * (i + 1 + iy) + (iw - 3 + 1 + ix);
            int i2 = lw;
            while (i2 >= 0) {
                int idx_p1 = idx_0 + stride;
                int idx_m1 = idx_0 - stride;
                int b = buf[idx_m1 - 1];
                int d = buf[idx_m1 + 1];
                int h = buf[idx_p1 - 1];
                int f = buf[idx_p1 + 1];
                int vx = (buf[idx_0 + 1] - buf[idx_0 - 1] >> 1) + (d - b + f - h >> 2);
                int vy = (buf[idx_p1] - buf[idx_m1] >> 1) + (f - d + h - b >> 2);
                --idx_0;
                int wx = vx * vx;
                int wy = vy * vy;
                sum_wx += wx;
                sum_wy += wy;
                sum_vx += wx * vx;
                sum_vy += wy * vy;
                sum_x += wx * (i2 + 1);
                sum_y += wy * (i + 1);
                --i2;
            }
            --i;
        }
        if (sum_wx == 0) {
            xx = ix + (iw >> 1);
            o_posvec.dx = 0.0;
        } else {
            xx = (double)ix + (double)sum_x / (double)sum_wx;
            o_posvec.dx = (double)sum_vx / (double)sum_wx;
        }
        if (sum_wy == 0) {
            yy = iy + (ih >> 1);
            o_posvec.dy = 0.0;
        } else {
            yy = (double)iy + (double)sum_y / (double)sum_wy;
            o_posvec.dy = (double)sum_vy / (double)sum_wy;
        }
        if (this._factor != null) {
            this._factor.observ2Ideal(xx, yy, this.__tmp);
            o_posvec.x = this.__tmp.x;
            o_posvec.y = this.__tmp.y;
        } else {
            o_posvec.x = xx;
            o_posvec.y = yy;
        }
        return sum_wx + sum_wy;
    }

    @Override
    public final int getAreaVector22(int ix, int iy, int iw, int ih, NyARVecLinear2d o_posvec) {
        double yy;
        double xx;
        assert (ih >= 3 && iw >= 3);
        assert (ix >= 0 && iy >= 0 && ix + iw <= this._ref_base_raster.getWidth() && iy + ih <= this._ref_base_raster.getHeight());
        int[] buf = (int[])this._ref_base_raster.getBuffer();
        int stride = this._ref_base_raster.getWidth();
        int sum_vy = 0;
        int sum_vx = 0;
        int sum_wy = 0;
        int sum_wx = 0;
        int sum_y = 0;
        int sum_x = 0;
        int ll = iw - 1;
        int i = 0;
        while (i < ih - 1) {
            int idx_0 = stride * (i + iy) + ix + 1;
            int a = buf[idx_0 - 1];
            int b = buf[idx_0];
            int c = buf[idx_0 + stride - 1];
            int d = buf[idx_0 + stride];
            int i2 = 0;
            while (i2 < ll) {
                int vx = b - a + d - c >> 2;
                int vy = c - a + d - b >> 2;
                a = b;
                c = d;
                b = buf[++idx_0];
                d = buf[idx_0 + stride];
                int wx = vx * vx;
                sum_wx += wx;
                sum_vx += wx * vx;
                sum_x += wx * i2;
                int wy = vy * vy;
                sum_wy += wy;
                sum_vy += wy * vy;
                sum_y += wy * i;
                ++i2;
            }
            ++i;
        }
        if (sum_wx == 0) {
            xx = ix + (iw >> 1);
            o_posvec.dx = 0.0;
        } else {
            xx = (double)ix + (double)sum_x / (double)sum_wx;
            o_posvec.dx = (double)sum_vx / (double)sum_wx;
        }
        if (sum_wy == 0) {
            yy = iy + (ih >> 1);
            o_posvec.dy = 0.0;
        } else {
            yy = (double)iy + (double)sum_y / (double)sum_wy;
            o_posvec.dy = (double)sum_vy / (double)sum_wy;
        }
        if (this._factor != null) {
            this._factor.observ2Ideal(xx, yy, this.__tmp);
            o_posvec.x = this.__tmp.x;
            o_posvec.y = this.__tmp.y;
        } else {
            o_posvec.x = xx;
            o_posvec.y = yy;
        }
        return sum_wx + sum_wy;
    }
}

