/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core;

import jp.nyatla.nyartoolkit.core.NyARVertexCounter;

class NyARMarker {
    private static final int ALLOCATE_PAGE_SIZE = 256;
    private static final int INITIAL_SIZE = 1;
    int[] x_coord = new int[1];
    int[] y_coord = new int[1];
    int coord_num;
    int area;
    final double[] pos = new double[2];
    final int[] mkvertex = new int[5];
    private final NyARVertexCounter wk_checkSquare_wv1 = new NyARVertexCounter();
    private final NyARVertexCounter wk_checkSquare_wv2 = new NyARVertexCounter();

    NyARMarker() {
    }

    private void reallocCoordArray(int i_chain_num) {
        if (this.x_coord.length < i_chain_num) {
            int new_size = (i_chain_num + 256 - 1) / 256 * 256;
            this.x_coord = new int[new_size];
            this.y_coord = new int[new_size];
            this.coord_num = 0;
        }
    }

    public void setCoordXY(int i_v1, int i_coord_num, int[] i_xcoord, int[] i_ycoord) {
        this.reallocCoordArray(i_coord_num + 1);
        System.arraycopy(i_xcoord, i_v1, this.x_coord, 0, i_coord_num - i_v1);
        System.arraycopy(i_xcoord, 0, this.x_coord, i_coord_num - i_v1, i_v1);
        this.x_coord[i_coord_num] = this.x_coord[0];
        System.arraycopy(i_ycoord, i_v1, this.y_coord, 0, i_coord_num - i_v1);
        System.arraycopy(i_ycoord, 0, this.y_coord, i_coord_num - i_v1, i_v1);
        this.y_coord[i_coord_num] = this.y_coord[0];
        this.coord_num = i_coord_num + 1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean checkSquare(int i_area, double i_factor, double i_pos_x, double i_pos_y) {
        int[] l_vertex = this.mkvertex;
        int[] l_x_coord = this.x_coord;
        int[] l_y_coord = this.y_coord;
        NyARVertexCounter wv1 = this.wk_checkSquare_wv1;
        NyARVertexCounter wv2 = this.wk_checkSquare_wv2;
        int L_coord_num_m1 = this.coord_num - 1;
        int dmax = 0;
        int v1 = 0;
        int sx = l_x_coord[0];
        int sy = l_y_coord[0];
        for (int i = 1; i < L_coord_num_m1; ++i) {
            int d = (l_x_coord[i] - sx) * (l_x_coord[i] - sx) + (l_y_coord[i] - sy) * (l_y_coord[i] - sy);
            if (d <= dmax) continue;
            dmax = d;
            v1 = i;
        }
        double thresh = (double)i_area / 0.75 * 0.01 * i_factor;
        l_vertex[0] = 0;
        if (!wv1.getVertex(l_x_coord, l_y_coord, 0, v1, thresh)) {
            return false;
        }
        if (!wv2.getVertex(l_x_coord, l_y_coord, v1, L_coord_num_m1, thresh)) {
            return false;
        }
        if (wv1.number_of_vertex == 1 && wv2.number_of_vertex == 1) {
            l_vertex[1] = wv1.vertex[0];
            l_vertex[2] = v1;
            l_vertex[3] = wv2.vertex[0];
        } else if (wv1.number_of_vertex > 1 && wv2.number_of_vertex == 0) {
            int v2 = v1 / 2;
            if (!wv1.getVertex(l_x_coord, l_y_coord, 0, v2, thresh)) {
                return false;
            }
            if (!wv2.getVertex(l_x_coord, l_y_coord, v2, v1, thresh)) {
                return false;
            }
            if (wv1.number_of_vertex != 1 || wv2.number_of_vertex != 1) return false;
            l_vertex[1] = wv1.vertex[0];
            l_vertex[2] = wv2.vertex[0];
            l_vertex[3] = v1;
        } else {
            if (wv1.number_of_vertex != 0 || wv2.number_of_vertex <= 1) return false;
            int v2 = (v1 + this.coord_num - 1) / 2;
            if (!wv1.getVertex(l_x_coord, l_y_coord, v1, v2, thresh)) {
                return false;
            }
            if (!wv2.getVertex(l_x_coord, l_y_coord, v2, L_coord_num_m1, thresh)) {
                return false;
            }
            if (wv1.number_of_vertex != 1 || wv2.number_of_vertex != 1) return false;
            l_vertex[1] = v1;
            l_vertex[2] = wv1.vertex[0];
            l_vertex[3] = wv2.vertex[0];
        }
        l_vertex[4] = L_coord_num_m1;
        this.area = i_area;
        this.pos[0] = i_pos_x;
        this.pos[1] = i_pos_y;
        return true;
    }
}

