/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core.utils;

import jp.nyatla.nyartoolkit.NyARException;
import jp.nyatla.nyartoolkit.core.types.NyARIntPoint2d;
import jp.nyatla.nyartoolkit.core.utils.NyARSystemOfLinearEquationsProcessor;

public class NyARPerspectiveParamGenerator {
    protected int _local_x;
    protected int _local_y;
    protected int _width;
    protected int _height;

    public NyARPerspectiveParamGenerator(int i_local_x, int i_local_y, int i_width, int i_height) {
        this._height = i_height;
        this._width = i_width;
        this._local_x = i_local_x;
        this._local_y = i_local_y;
    }

    public boolean getParam(NyARIntPoint2d[] i_vertex, double[] o_param) throws NyARException {
        double A;
        double ltx = this._local_x;
        double lty = this._local_y;
        double rbx = ltx + (double)this._width;
        double rby = lty + (double)this._height;
        double[][] la1 = new double[4][5];
        double[][] la2 = new double[4][5];
        double[] ra1 = new double[4];
        double[] ra2 = new double[4];
        la1[0][0] = ltx;
        la1[0][1] = lty;
        la1[0][2] = 1.0;
        la1[0][3] = -ltx * (double)i_vertex[0].x;
        la1[0][4] = -lty * (double)i_vertex[0].x;
        la1[1][0] = rbx;
        la1[1][1] = lty;
        la1[1][2] = 1.0;
        la1[1][3] = -rbx * (double)i_vertex[1].x;
        la1[1][4] = -lty * (double)i_vertex[1].x;
        la1[2][0] = rbx;
        la1[2][1] = rby;
        la1[2][2] = 1.0;
        la1[2][3] = -rbx * (double)i_vertex[2].x;
        la1[2][4] = -rby * (double)i_vertex[2].x;
        la1[3][0] = ltx;
        la1[3][1] = rby;
        la1[3][2] = 1.0;
        la1[3][3] = -ltx * (double)i_vertex[3].x;
        la1[3][4] = -rby * (double)i_vertex[3].x;
        ra1[0] = i_vertex[0].x;
        ra1[1] = i_vertex[1].x;
        ra1[2] = i_vertex[2].x;
        ra1[3] = i_vertex[3].x;
        NyARSystemOfLinearEquationsProcessor.doGaussianElimination(la1, ra1, 5, 4);
        la2[0][0] = ltx;
        la2[0][1] = lty;
        la2[0][2] = 1.0;
        la2[0][3] = -ltx * (double)i_vertex[0].y;
        la2[0][4] = -lty * (double)i_vertex[0].y;
        la2[1][0] = rbx;
        la2[1][1] = lty;
        la2[1][2] = 1.0;
        la2[1][3] = -rbx * (double)i_vertex[1].y;
        la2[1][4] = -lty * (double)i_vertex[1].y;
        la2[2][0] = rbx;
        la2[2][1] = rby;
        la2[2][2] = 1.0;
        la2[2][3] = -rbx * (double)i_vertex[2].y;
        la2[2][4] = -rby * (double)i_vertex[2].y;
        la2[3][0] = ltx;
        la2[3][1] = rby;
        la2[3][2] = 1.0;
        la2[3][3] = -ltx * (double)i_vertex[3].y;
        la2[3][4] = -rby * (double)i_vertex[3].y;
        ra2[0] = i_vertex[0].y;
        ra2[1] = i_vertex[1].y;
        ra2[2] = i_vertex[2].y;
        ra2[3] = i_vertex[3].y;
        NyARSystemOfLinearEquationsProcessor.doGaussianElimination(la2, ra2, 5, 4);
        double H = (ra2[3] - ra1[3]) / (la2[3][4] - la1[3][4]);
        double G = ra2[3] - la2[3][4] * H;
        double F = ra2[2] - H * la2[2][4] - G * la2[2][3];
        double E = ra2[1] - H * la2[1][4] - G * la2[1][3] - F * la2[1][2];
        double D = ra2[0] - H * la2[0][4] - G * la2[0][3] - F * la2[0][2] - E * la2[0][1];
        double C = ra1[2] - H * la1[2][4] - G * la1[2][3];
        double B = ra1[1] - H * la1[1][4] - G * la1[1][3] - C * la1[1][2];
        o_param[0] = A = ra1[0] - H * la1[0][4] - G * la1[0][3] - C * la1[0][2] - B * la1[0][1];
        o_param[1] = B;
        o_param[2] = C;
        o_param[3] = D;
        o_param[4] = E;
        o_param[5] = F;
        o_param[6] = G;
        o_param[7] = H;
        return true;
    }
}

