/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.sample;

import java.io.File;
import java.io.FileInputStream;
import jp.nyatla.nyartoolkit.core.param.NyARParam;
import jp.nyatla.nyartoolkit.core.raster.rgb.NyARRgbRaster_RGB;
import jp.nyatla.nyartoolkit.core.squaredetect.NyARSquare;
import jp.nyatla.nyartoolkit.core.transmat.NyARTransMatResult;
import jp.nyatla.nyartoolkit.nyidmarker.data.INyIdMarkerData;
import jp.nyatla.nyartoolkit.nyidmarker.data.NyIdMarkerDataEncoder_RawBit;
import jp.nyatla.nyartoolkit.nyidmarker.data.NyIdMarkerData_RawBit;
import jp.nyatla.nyartoolkit.processor.SingleNyIdMarkerProcesser;

public class NyIdTest {
    private final String data_file = "../Data/320x240NyId.raw";
    private final String camera_file = "../Data/camera_para.dat";

    public void Test() throws Exception {
        NyARParam ap = new NyARParam();
        ap.loadARParamFromFile("../Data/camera_para.dat");
        ap.changeScreenSize(320, 240);
        File f = new File("../Data/320x240NyId.raw");
        FileInputStream fs = new FileInputStream("../Data/320x240NyId.raw");
        byte[] buf = new byte[(int)f.length()];
        fs.read(buf);
        NyARRgbRaster_RGB ra = new NyARRgbRaster_RGB(320, 240, false);
        ra.wrapBuffer(buf);
        MarkerProcessor pr = new MarkerProcessor(ap, ra.getBufferType());
        pr.detectMarker(ra);
    }

    public static void main(String[] args) {
        try {
            NyIdTest t = new NyIdTest();
            t.Test();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public class MarkerProcessor
    extends SingleNyIdMarkerProcesser {
        private Object _sync_object = new Object();
        public NyARTransMatResult transmat = null;
        public int current_id = -1;

        public MarkerProcessor(NyARParam i_cparam, int i_raster_format) throws Exception {
            this.initInstance(i_cparam, new NyIdMarkerDataEncoder_RawBit(), 100, i_raster_format);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void onEnterHandler(INyIdMarkerData i_code) {
            Object object = this._sync_object;
            synchronized (object) {
                NyIdMarkerData_RawBit code = (NyIdMarkerData_RawBit)i_code;
                if (code.length > 4) {
                    this.current_id = -1;
                } else {
                    this.current_id = 0;
                    int i = 0;
                    while (i < code.length) {
                        this.current_id = this.current_id << 8 | code.packet[i];
                        ++i;
                    }
                }
                this.transmat = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void onLeaveHandler() {
            Object object = this._sync_object;
            synchronized (object) {
                this.current_id = -1;
                this.transmat = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void onUpdateHandler(NyARSquare i_square, NyARTransMatResult result) {
            Object object = this._sync_object;
            synchronized (object) {
                this.transmat = result;
            }
        }
    }
}

