/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core.raster;

import jp.nyatla.nyartoolkit.core.raster.NyARRaster;

public class NyARRaster_BGRA
implements NyARRaster {
    private byte[] ref_buf;
    private int width;
    private int height;

    public static NyARRaster_BGRA wrap(byte[] i_buffer, int i_width, int i_height) {
        NyARRaster_BGRA new_inst = new NyARRaster_BGRA();
        new_inst.ref_buf = i_buffer;
        new_inst.width = i_width;
        new_inst.height = i_height;
        return new_inst;
    }

    @Override
    public int getPixelTotal(int i_x, int i_y) {
        int bp = (i_x + i_y * this.width) * 4;
        byte[] ref = this.ref_buf;
        return (ref[bp] & 0xFF) + (ref[bp + 1] & 0xFF) + (ref[bp + 2] & 0xFF);
    }

    @Override
    public void getPixelTotalRowLine(int i_row, int[] o_line) {
        byte[] ref = this.ref_buf;
        int bp = (i_row + 1) * this.width * 4 - 4;
        for (int i = this.width - 1; i >= 0; --i) {
            o_line[i] = (ref[bp] & 0xFF) + (ref[bp + 1] & 0xFF) + (ref[bp + 2] & 0xFF);
            bp -= 4;
        }
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public void getPixel(int i_x, int i_y, int[] i_rgb) {
        byte[] ref = this.ref_buf;
        int bp = (i_x + i_y * this.width) * 4;
        i_rgb[0] = ref[bp + 2] & 0xFF;
        i_rgb[1] = ref[bp + 1] & 0xFF;
        i_rgb[2] = ref[bp + 0] & 0xFF;
    }

    @Override
    public void getPixelSet(int[] i_x, int[] i_y, int i_num, int[] o_rgb) {
        int width = this.width;
        byte[] ref = this.ref_buf;
        for (int i = i_num - 1; i >= 0; --i) {
            int bp = (i_x[i] + i_y[i] * width) * 4;
            o_rgb[i * 3 + 0] = ref[bp + 2] & 0xFF;
            o_rgb[i * 3 + 1] = ref[bp + 1] & 0xFF;
            o_rgb[i * 3 + 2] = ref[bp + 0] & 0xFF;
        }
    }
}

