/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.rpf.reality.nyartk;

import jp.nyatla.nyartoolkit.core.NyARException;
import jp.nyatla.nyartoolkit.core.param.NyARCameraDistortionFactor;
import jp.nyatla.nyartoolkit.core.param.NyARFrustum;
import jp.nyatla.nyartoolkit.core.param.NyARParam;
import jp.nyatla.nyartoolkit.core.param.NyARPerspectiveProjectionMatrix;
import jp.nyatla.nyartoolkit.core.raster.rgb.INyARRgbRaster;
import jp.nyatla.nyartoolkit.core.squaredetect.NyARSquare;
import jp.nyatla.nyartoolkit.core.transmat.INyARTransMat;
import jp.nyatla.nyartoolkit.core.transmat.NyARTransMat;
import jp.nyatla.nyartoolkit.core.types.NyARDoublePoint2d;
import jp.nyatla.nyartoolkit.core.types.NyARDoublePoint3d;
import jp.nyatla.nyartoolkit.core.types.NyARIntPoint2d;
import jp.nyatla.nyartoolkit.core.types.NyARIntSize;
import jp.nyatla.nyartoolkit.core.types.NyARLinear;
import jp.nyatla.nyartoolkit.core.types.matrix.NyARDoubleMatrix44;
import jp.nyatla.nyartoolkit.rpf.reality.nyartk.NyARRealityTarget;
import jp.nyatla.nyartoolkit.rpf.reality.nyartk.NyARRealityTargetList;
import jp.nyatla.nyartoolkit.rpf.reality.nyartk.NyARRealityTargetPool;
import jp.nyatla.nyartoolkit.rpf.realitysource.nyartk.NyARRealitySource;
import jp.nyatla.nyartoolkit.rpf.tracker.nyartk.NyARTarget;
import jp.nyatla.nyartoolkit.rpf.tracker.nyartk.NyARTargetList;
import jp.nyatla.nyartoolkit.rpf.tracker.nyartk.NyARTracker;
import jp.nyatla.nyartoolkit.rpf.tracker.nyartk.status.NyARRectTargetStatus;

public class NyARReality {
    public static final double FRASTRAM_ARTK_NEAR = 10.0;
    public static final double FRASTRAM_ARTK_FAR = 10000.0;
    protected NyARFrustum _frustum;
    protected NyARPerspectiveProjectionMatrix _ref_prjmat;
    private final int MAX_LIMIT_UNKNOWN;
    private final int MAX_LIMIT_KNOWN;
    private NyARRealityTargetPool _pool;
    private NyARRealityTargetList target;
    private int _number_of_unknown;
    private int _number_of_known;
    private int _number_of_dead;
    private NyARTracker _tracker;
    private INyARTransMat _transmat;
    private NyARLinear __tmp_l = new NyARLinear();

    public NyARReality(NyARParam i_param, double i_near, double i_far, int i_max_known_target, int i_max_unknown_target) throws NyARException {
        this.MAX_LIMIT_KNOWN = i_max_known_target;
        this.MAX_LIMIT_UNKNOWN = i_max_unknown_target;
        this.initInstance(i_param.getScreenSize(), i_near, i_far, i_param.getPerspectiveProjectionMatrix(), i_param.getDistortionFactor());
    }

    public NyARReality(NyARIntSize i_screen, double i_near, double i_far, NyARPerspectiveProjectionMatrix i_prjmat, NyARCameraDistortionFactor i_dist_factor, int i_max_known_target, int i_max_unknown_target) throws NyARException {
        this.MAX_LIMIT_KNOWN = i_max_known_target;
        this.MAX_LIMIT_UNKNOWN = i_max_unknown_target;
        this.initInstance(i_screen, i_near, i_far, i_prjmat, i_dist_factor);
    }

    protected void initInstance(NyARIntSize i_screen, double i_near, double i_far, NyARPerspectiveProjectionMatrix i_prjmat, NyARCameraDistortionFactor i_dist_factor) throws NyARException {
        int number_of_reality_target = this.MAX_LIMIT_KNOWN + this.MAX_LIMIT_UNKNOWN;
        this._transmat = new NyARTransMat(i_dist_factor, i_prjmat);
        this._pool = new NyARRealityTargetPool(number_of_reality_target, i_prjmat);
        this.target = new NyARRealityTargetList(number_of_reality_target);
        this._tracker = new NyARTracker((this.MAX_LIMIT_KNOWN + this.MAX_LIMIT_UNKNOWN) * 2, 1, this.MAX_LIMIT_KNOWN * 2);
        this._ref_prjmat = i_prjmat;
        this._frustum = new NyARFrustum(i_prjmat, i_screen.w, i_screen.h, i_near, i_far);
        this._number_of_known = 0;
        this._number_of_unknown = 0;
        this._number_of_dead = 0;
    }

    public void progress(NyARRealitySource i_in) throws NyARException {
        this._tracker.progress(i_in.makeTrackSource());
        NyARTarget tt = NyARReality.findEmptyTagItem(this._tracker._targets);
        if (tt != null) {
            this.addUnknownTarget(tt);
        }
        this.updateLists();
        this.upgradeLists();
    }

    private final void upgradeLists() throws NyARException {
        NyARRealityTarget[] rt_array = (NyARRealityTarget[])this.target.getArray();
        int i = this.target.getLength() - 1;
        while (i >= 0) {
            switch (rt_array[i]._target_type) {
                case 4: {
                    this.deleteTarget(i);
                    break;
                }
                case 0: 
                case 2: {
                    if (this.isTargetAlive(rt_array[i])) break;
                    this.changeTargetToDead(rt_array[i]);
                    break;
                }
                default: {
                    throw new NyARException();
                }
            }
            --i;
        }
    }

    private final void updateLists() throws NyARException {
        NyARRealityTarget[] rt_array = (NyARRealityTarget[])this.target.getArray();
        int i = this.target.getLength() - 1;
        while (i >= 0) {
            NyARRealityTarget tar = rt_array[i];
            if (tar._ref_tracktarget._delay_tick == 0) {
                tar._grab_rate += 3;
                if (tar._grab_rate > 100) {
                    tar._grab_rate = 100;
                }
                switch (tar._target_type) {
                    case 4: {
                        break;
                    }
                    case 2: {
                        this.setSquare(((NyARRectTargetStatus)tar._ref_tracktarget._ref_status).vertex, tar._screen_square);
                        this._transmat.transMatContinue(tar._screen_square, tar._offset, tar._transform_matrix, tar._transform_matrix);
                        break;
                    }
                    case 0: {
                        break;
                    }
                }
            } else {
                tar._grab_rate -= 3 * tar._ref_tracktarget._delay_tick;
                if (tar._grab_rate < 0) {
                    tar._grab_rate = 0;
                }
            }
            --i;
        }
    }

    private final void setSquare(NyARDoublePoint2d[] i_vx, NyARSquare i_s) {
        NyARLinear l = this.__tmp_l;
        int i = 3;
        while (i >= 0) {
            i_s.sqvertex[i].setValue(i_vx[i]);
            l.makeLinearWithNormalize(i_vx[i], i_vx[(i + 1) % 4]);
            i_s.line[i].a = i_s.line[i].a * 0.6 + l.a * 0.4;
            i_s.line[i].b = i_s.line[i].b * 0.6 + l.b * 0.4;
            i_s.line[i].c = i_s.line[i].c * 0.6 + l.c * 0.4;
            --i;
        }
        i = 3;
        while (i >= 0) {
            i_s.line[i].crossPos(i_s.line[(i + 3) % 4], i_s.sqvertex[i]);
            --i;
        }
    }

    private final boolean isTargetAlive(NyARRealityTarget i_target) {
        return i_target._ref_tracktarget._st_type == 2;
    }

    private static final NyARTarget findEmptyTagItem(NyARTargetList i_list) {
        NyARTarget[] items = (NyARTarget[])i_list.getArray();
        int i = i_list.getLength() - 1;
        while (i >= 0) {
            if (items[i]._st_type == 2 && items[i].tag == null) {
                return items[i];
            }
            --i;
        }
        return null;
    }

    private final NyARRealityTarget addUnknownTarget(NyARTarget i_track_target) throws NyARException {
        assert (i_track_target._st_type == 2);
        NyARRealityTarget rt = this._pool.newNewTarget(i_track_target);
        if (rt == null) {
            return null;
        }
        if (this._number_of_unknown >= this.MAX_LIMIT_UNKNOWN) {
            return null;
        }
        rt._target_type = 0;
        this.target.pushAssert(rt);
        ++this._number_of_unknown;
        return rt;
    }

    private final void deleteTarget(int i_index) {
        assert (((NyARRealityTarget)this.target.getItem((int)i_index))._target_type == 4);
        ((NyARRealityTarget)this.target.getItem(i_index)).releaseObject();
        this.target.removeIgnoreOrder(i_index);
        --this._number_of_dead;
    }

    public final boolean changeTargetToKnown(NyARRealityTarget i_item, int i_dir, double i_marker_size) throws NyARException {
        return this.changeTargetToKnown(i_item, i_dir, i_marker_size, i_marker_size);
    }

    public final boolean changeTargetToKnown(NyARRealityTarget i_item, int i_dir, double i_marker_width, double i_marker_height) throws NyARException {
        if (i_item._target_type != 0) {
            return false;
        }
        if (i_item._ref_tracktarget._st_type != 2) {
            return false;
        }
        if (this._number_of_known >= this.MAX_LIMIT_KNOWN) {
            return false;
        }
        i_item._target_type = 2;
        i_item._offset.setSquare(i_marker_width, i_marker_height);
        ((NyARRectTargetStatus)i_item._ref_tracktarget._ref_status).shiftByArtkDirection((4 - i_dir) % 4);
        NyARDoublePoint2d[] vx = ((NyARRectTargetStatus)i_item._ref_tracktarget._ref_status).vertex;
        int i = 3;
        while (i >= 0) {
            i_item._screen_square.sqvertex[i].setValue(vx[i]);
            i_item._screen_square.line[i].makeLinearWithNormalize(vx[i], vx[(i + 1) % 4]);
            --i;
        }
        this._transmat.transMat(i_item._screen_square, i_item._offset, i_item._transform_matrix);
        --this._number_of_unknown;
        ++this._number_of_known;
        return true;
    }

    public final void changeTargetToDead(NyARRealityTarget i_item) throws NyARException {
        this.changeTargetToDead(i_item, 50);
    }

    public final void changeTargetToDead(NyARRealityTarget i_item, int i_dead_cycle) throws NyARException {
        assert (i_item._target_type == 0 || i_item._target_type == 2);
        if (i_item._ref_tracktarget._st_type != 0) {
            this._tracker.changeStatusToIgnore(i_item._ref_tracktarget, i_dead_cycle);
        }
        if (i_item._target_type == 0) {
            --this._number_of_unknown;
        } else {
            --this._number_of_known;
        }
        i_item._target_type = 4;
        ++this._number_of_dead;
    }

    public final boolean changeTargetToKnownBySerial(long i_serial, int i_dir, double i_marker_width) throws NyARException {
        NyARRealityTarget item = this.target.getItemBySerial(i_serial);
        if (item == null) {
            return false;
        }
        return this.changeTargetToKnown(item, i_dir, i_marker_width);
    }

    public final NyARRealityTarget changeTargetToDeadBySerial(long i_serial) throws NyARException {
        NyARRealityTarget item = this.target.getItemBySerial(i_serial);
        if (item == null) {
            return null;
        }
        this.changeTargetToDead(item);
        return item;
    }

    public final int getNumberOfUnknown() {
        return this._number_of_unknown;
    }

    public final int getNumberOfKnown() {
        return this._number_of_known;
    }

    public final int getNumberOfDead() {
        return this._number_of_dead;
    }

    public NyARRealityTargetList refTargetList() {
        return this.target;
    }

    public int selectKnownTargets(NyARRealityTarget[] o_result) {
        return this.target.selectTargetsByType(2, o_result);
    }

    public int selectUnKnownTargets(NyARRealityTarget[] o_result) {
        return this.target.selectTargetsByType(0, o_result);
    }

    public NyARRealityTarget selectSingleUnknownTarget() {
        return this.target.selectSingleTargetByType(0);
    }

    public NyARFrustum refFrustum() {
        return this._frustum;
    }

    public NyARPerspectiveProjectionMatrix refPerspectiveProjectionMatrix() {
        return this._ref_prjmat;
    }

    public final boolean getRgbPatt2d(NyARRealitySource i_src, NyARIntPoint2d[] i_vertex, int i_resolution, INyARRgbRaster o_raster) throws NyARException {
        return i_src.refPerspectiveRasterReader().copyPatt(i_vertex, 0, 0, i_resolution, o_raster);
    }

    public final boolean getRgbPatt2d(NyARRealitySource i_src, NyARDoublePoint2d[] i_vertex, int i_resolution, INyARRgbRaster o_raster) throws NyARException {
        return i_src.refPerspectiveRasterReader().copyPatt(i_vertex, 0, 0, i_resolution, o_raster);
    }

    public final boolean getRgbPatt3d(NyARRealitySource i_src, NyARDoublePoint3d[] i_vertex, NyARDoubleMatrix44 i_matrix, int i_resolution, INyARRgbRaster o_raster) throws NyARException {
        NyARDoublePoint2d[] vx = NyARDoublePoint2d.createArray(4);
        if (i_matrix != null) {
            NyARDoublePoint3d v3d = new NyARDoublePoint3d();
            int i = 3;
            while (i >= 0) {
                i_matrix.transform3d(i_vertex[i], v3d);
                this._ref_prjmat.project(v3d, vx[i]);
                --i;
            }
        } else {
            int i = 3;
            while (i >= 0) {
                this._ref_prjmat.project(i_vertex[i], vx[i]);
                --i;
            }
        }
        return i_src.refPerspectiveRasterReader().copyPatt(vx, 0, 0, i_resolution, o_raster);
    }
}

