/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core.match;

import jp.nyatla.nyartoolkit.core.NyARCode;
import jp.nyatla.nyartoolkit.core.NyARException;
import jp.nyatla.nyartoolkit.core.match.INyARMatchPatt;
import jp.nyatla.nyartoolkit.core.match.NyARMatchPattDeviationColorData;
import jp.nyatla.nyartoolkit.core.match.NyARMatchPattResult;

public class NyARMatchPatt_Color_WITHOUT_PCA
implements INyARMatchPatt {
    protected NyARCode _code_patt;
    protected int _optimize_for_mod;
    protected int _rgbpixels;

    public NyARMatchPatt_Color_WITHOUT_PCA(NyARCode i_code_ref) {
        int w = i_code_ref.getWidth();
        int h = i_code_ref.getHeight();
        this._rgbpixels = w * h * 3;
        this._optimize_for_mod = this._rgbpixels - this._rgbpixels % 16;
        this.setARCode(i_code_ref);
    }

    public NyARMatchPatt_Color_WITHOUT_PCA(int i_width, int i_height) {
        this._rgbpixels = i_height * i_width * 3;
        this._optimize_for_mod = this._rgbpixels - this._rgbpixels % 16;
    }

    @Override
    public void setARCode(NyARCode i_code_ref) {
        this._code_patt = i_code_ref;
    }

    public boolean evaluate(NyARMatchPattDeviationColorData i_patt, NyARMatchPattResult o_result) throws NyARException {
        assert (this._code_patt != null);
        int[] linput = i_patt.getData();
        double max = 0.0;
        int res = -1;
        int for_mod = this._optimize_for_mod;
        int j = 0;
        while (j < 4) {
            int sum = 0;
            NyARMatchPattDeviationColorData code_patt = this._code_patt.getColorData(j);
            int[] pat_j = code_patt.getData();
            int i = this._rgbpixels - 1;
            while (i >= for_mod) {
                sum += linput[i] * pat_j[i];
                --i;
            }
            while (i >= 0) {
                sum += linput[i] * pat_j[i];
                sum += linput[--i] * pat_j[i];
                sum += linput[--i] * pat_j[i];
                sum += linput[--i] * pat_j[i];
                sum += linput[--i] * pat_j[i];
                sum += linput[--i] * pat_j[i];
                sum += linput[--i] * pat_j[i];
                sum += linput[--i] * pat_j[i];
                sum += linput[--i] * pat_j[i];
                sum += linput[--i] * pat_j[i];
                sum += linput[--i] * pat_j[i];
                sum += linput[--i] * pat_j[i];
                sum += linput[--i] * pat_j[i];
                sum += linput[--i] * pat_j[i];
                sum += linput[--i] * pat_j[i];
                sum += linput[--i] * pat_j[i];
                --i;
            }
            double sum2 = (double)sum / code_patt.getPow();
            if (sum2 > max) {
                max = sum2;
                res = j;
            }
            ++j;
        }
        o_result.direction = res;
        o_result.confidence = max / i_patt.getPow();
        return true;
    }
}

