/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.test;

import java.io.File;
import java.io.FileInputStream;
import jp.nyatla.nyartoolkit.core.param.NyARParam;
import jp.nyatla.nyartoolkit.core.raster.rgb.NyARRgbRaster;
import jp.nyatla.nyartoolkit.core.squaredetect.NyARSquare;
import jp.nyatla.nyartoolkit.core.types.matrix.NyARDoubleMatrix44;
import jp.nyatla.nyartoolkit.nyidmarker.data.INyIdMarkerData;
import jp.nyatla.nyartoolkit.nyidmarker.data.NyIdMarkerDataEncoder_RawBitId;
import jp.nyatla.nyartoolkit.nyidmarker.data.NyIdMarkerData_RawBitId;
import jp.nyatla.nyartoolkit.processor.SingleNyIdMarkerProcesser;

public class NyIdTest {
    private final String data_file = "../Data/320x240NyId.raw";
    private final String camera_file = "../Data/camera_para.dat";

    public void Test() throws Exception {
        NyARParam ap = NyARParam.createFromARParamFile(new FileInputStream("../Data/camera_para.dat"));
        ap.changeScreenSize(320, 240);
        File f = new File("../Data/320x240NyId.raw");
        FileInputStream fs = new FileInputStream("../Data/320x240NyId.raw");
        byte[] buf = new byte[(int)f.length()];
        fs.read(buf);
        NyARRgbRaster ra = new NyARRgbRaster(320, 240, 65537, false);
        ra.wrapBuffer(buf);
        MarkerProcessor pr = new MarkerProcessor(ap, ra.getBufferType());
        pr.detectMarker(ra);
    }

    public static void main(String[] args) {
        try {
            NyIdTest t = new NyIdTest();
            t.Test();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public class MarkerProcessor
    extends SingleNyIdMarkerProcesser {
        private Object _sync_object = new Object();
        public NyARDoubleMatrix44 transmat = null;
        public int current_id = -1;

        public MarkerProcessor(NyARParam i_cparam, int i_raster_format) throws Exception {
            this.initInstance(i_cparam, new NyIdMarkerDataEncoder_RawBitId(), 100.0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void onEnterHandler(INyIdMarkerData i_code) {
            Object object = this._sync_object;
            synchronized (object) {
                NyIdMarkerData_RawBitId code = (NyIdMarkerData_RawBitId)i_code;
                System.out.println("NyARId:" + code.marker_id);
                this.transmat = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void onLeaveHandler() {
            Object object = this._sync_object;
            synchronized (object) {
                this.current_id = -1;
                this.transmat = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void onUpdateHandler(NyARSquare i_square, NyARDoubleMatrix44 result) {
            Object object = this._sync_object;
            synchronized (object) {
                this.transmat = result;
            }
        }
    }
}

