package jp.ac.kyutech.ai.ylab.shiva.nativecapable.plugin.properties;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PropertyPage;

public class NativeCapableJavaProjectPropertyPage extends PropertyPage {

	public static final String SRC_DIR_TITLE = "&Src directory:";
	public static final String SRC_DIR_PROPERTY = "SRC";
	public static final String SRC_DIR_DEFAULT = "src";

	public static final String LIB_DIR_TITLE = "&Lib directory:";
	public static final String LIB_DIR_PROPERTY = "LIB";
	public static final String LIB_DIR_DEFAULT = "lib";

	public static final String BIN_DIR_TITLE = "&Bin directory:";
	public static final String BIN_DIR_PROPERTY = "BIN";
	public static final String BIN_DIR_DEFAULT = "bin";

	private Text srcDirText;
	private Text libDirText;
	private Text binDirText;

	/**
	 * Constructor for SamplePropertyPage.
	 */
	public NativeCapableJavaProjectPropertyPage() {
		super();
	}

	/**
	 * @see PreferencePage#createContents(Composite)
	 */
	protected Control createContents(Composite parent) {
		String srcDir = "";
		String libDir = "";
		String binDir = "";

		try {
			srcDir = ((IJavaProject) getElement())
					.getProject()
					.getPersistentProperty(
							new QualifiedName(
									"",
									NativeCapableJavaProjectPropertyPage.SRC_DIR_PROPERTY));
			libDir = ((IJavaProject) getElement())
					.getProject()
					.getPersistentProperty(
							new QualifiedName(
									"",
									NativeCapableJavaProjectPropertyPage.LIB_DIR_PROPERTY));
			binDir = ((IJavaProject) getElement())
					.getProject()
					.getPersistentProperty(
							new QualifiedName(
									"",
									NativeCapableJavaProjectPropertyPage.BIN_DIR_PROPERTY));

		} catch (CoreException e) {
			e.printStackTrace();
			Label label = new Label(parent, SWT.NONE);
			label.setText("Exception's been occurred.");
			return label;
		}

		Composite container = new Composite(parent, SWT.NULL);

		GridLayout layout = new GridLayout();
		container.setLayout(layout);
		layout.numColumns = 2;
		layout.verticalSpacing = 9;

		Label label = new Label(container, SWT.NULL);
		label.setText(SRC_DIR_TITLE);

		srcDirText = new Text(container, SWT.BORDER | SWT.SINGLE);
		GridData gd = new GridData(GridData.FILL_HORIZONTAL);
		srcDirText.setLayoutData(gd);
		srcDirText.setText(srcDir);
		srcDirText.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				dialogChanged();
			}
		});

		label = new Label(container, SWT.NULL);
		label.setText(BIN_DIR_TITLE);

		binDirText = new Text(container, SWT.BORDER | SWT.SINGLE);
		gd = new GridData(GridData.FILL_HORIZONTAL);
		binDirText.setLayoutData(gd);
		binDirText.setText(binDir);
		binDirText.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				dialogChanged();
			}
		});

		label = new Label(container, SWT.NULL);
		label.setText(LIB_DIR_TITLE);

		libDirText = new Text(container, SWT.BORDER | SWT.SINGLE);
		gd = new GridData(GridData.FILL_HORIZONTAL);
		libDirText.setLayoutData(gd);
		libDirText.setText(libDir);
		libDirText.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				dialogChanged();
			}
		});

		dialogChanged();

		return container;
	}

	/**
	 * Ensures that both text fields are set.
	 */
	private void dialogChanged() {

		String srcFolderName = srcDirText.getText();
		String binFolderName = binDirText.getText();
		String libFolderName = libDirText.getText();

		if (srcFolderName.length() == 0) {
			updateStatus("Source directory must be specified");
			return;
		}
		if (srcFolderName.replace('\\', '/').indexOf('/', 1) > 0) {
			updateStatus("Source directory name must be valid");
			return;
		}

		if (binFolderName.length() == 0) {
			updateStatus("Binary directory must be specified");
			return;
		}
		if (binFolderName.replace('\\', '/').indexOf('/', 1) > 0) {
			updateStatus("Binary directory name must be valid");
			return;
		}

		if (libFolderName.length() == 0) {
			updateStatus("Library directory must be specified");
			return;
		}
		if (libFolderName.replace('\\', '/').indexOf('/', 1) > 0) {
			updateStatus("Library directory name must be valid");
			return;
		}

		updateStatus(null);
	}

	private void updateStatus(String message) {
		setErrorMessage(message);
		setValid(message == null);
	}

	protected void performDefaults() {
		// Populate the owner text field with the default value
		srcDirText.setText(SRC_DIR_DEFAULT);
		libDirText.setText(LIB_DIR_DEFAULT);
		binDirText.setText(BIN_DIR_DEFAULT);
	}

	public boolean performOk() {
		// store the value in the owner text field
		try {
			((IJavaProject) getElement()).getProject().setPersistentProperty(
					new QualifiedName("", SRC_DIR_PROPERTY),
					srcDirText.getText());
		} catch (CoreException e) {
			return false;
		}
		return true;
	}

}