/* 
* PROJECT: NyARToolkitCPP
* --------------------------------------------------------------------------------
*
* The NyARToolkitCPP is C++ version NyARToolkit class library.
* Copyright (C)2008-2009 Ryo Iizuka
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
* 
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>.
* 
* For further information please contact.
*	http://nyatla.jp/nyatoolkit/
*	<airmail(at)ebony.plala.or.jp> or <nyatla(at)nyatla.jp>
* 
*/
#include "nyarcore.h"
#include "NyARRaster_BasicClass.h"
namespace NyARToolkitCPP
{
	NyARRaster_BasicClass::NyARRaster_BasicClass(int i_width,int i_height)
	{
		this->_size.w=i_width;
		this->_size.h=i_height;
		return;
	}

	NyARRaster_BasicClass::NyARRaster_BasicClass(const TNyARIntSize& i_size)
	{
		this->_size=i_size;
		return;
	}

	 int NyARRaster_BasicClass::getWidth() const
	{
		return this->_size.w;
	}

	 int NyARRaster_BasicClass::getHeight() const
	{
		return this->_size.h;
	}

	 const TNyARIntSize& NyARRaster_BasicClass::getSize() const
	{
		return this->_size;
	}
}
