/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core.rasterfilter.gs;

import jp.nyatla.nyartoolkit.core.NyARException;
import jp.nyatla.nyartoolkit.core.raster.INyARGrayscaleRaster;
import jp.nyatla.nyartoolkit.core.rasterfilter.gs.INyARGsGaussianSmoothFilter;

class NyARGsGaussianSmoothFilter_GS8
implements INyARGsGaussianSmoothFilter {
    private INyARGrayscaleRaster _raster;

    public NyARGsGaussianSmoothFilter_GS8(INyARGrayscaleRaster i_raster) {
        assert (i_raster.isEqualBufferType(262145));
        this._raster = i_raster;
    }

    @Override
    public void doFilter(INyARGrayscaleRaster i_output) throws NyARException {
        int[] in_ptr = (int[])this._raster.getBuffer();
        int width = this._raster.getWidth();
        int height = this._raster.getHeight();
        int bptr = 0;
        switch (i_output.getBufferType()) {
            case 262145: {
                int col0;
                int[] out_ptr = (int[])i_output.getBuffer();
                bptr = 0;
                int col1 = in_ptr[bptr] * 2 + in_ptr[bptr + width];
                int col2 = in_ptr[bptr + 1] * 2 + in_ptr[bptr + width + 1];
                out_ptr[bptr] = (col1 * 2 + col2) / 9;
                ++bptr;
                int x = 0;
                while (x < width - 2) {
                    col0 = col1;
                    col1 = col2;
                    col2 = in_ptr[bptr + 1] * 2 + in_ptr[bptr + width + 1];
                    out_ptr[bptr] = (col0 + col1 * 2 + col2) / 12;
                    ++bptr;
                    ++x;
                }
                out_ptr[bptr] = (col1 + col2) / 9;
                ++bptr;
                int y = 0;
                while (y < height - 2) {
                    col1 = in_ptr[bptr] * 2 + in_ptr[bptr - width] + in_ptr[bptr + width];
                    col2 = in_ptr[bptr + 1] * 2 + in_ptr[bptr - width + 1] + in_ptr[bptr + width + 1];
                    out_ptr[bptr] = (col1 + col2) / 12;
                    ++bptr;
                    int x2 = 0;
                    while (x2 < width - 2) {
                        col0 = col1;
                        col1 = col2;
                        col2 = in_ptr[bptr + 1] * 2 + in_ptr[bptr - width + 1] + in_ptr[bptr + width + 1];
                        out_ptr[bptr] = (col0 + col1 * 2 + col2) / 16;
                        ++bptr;
                        ++x2;
                    }
                    out_ptr[bptr] = (col1 * 2 + col2) / 12;
                    ++bptr;
                    ++y;
                }
                col1 = in_ptr[bptr] * 2 + in_ptr[bptr - width];
                col2 = in_ptr[bptr + 1] * 2 + in_ptr[bptr - width + 1];
                out_ptr[bptr] = (col1 + col2) / 9;
                ++bptr;
                x = 0;
                while (x < width - 2) {
                    col0 = col1;
                    col1 = col2;
                    col2 = in_ptr[bptr + 1] * 2 + in_ptr[bptr - width + 1];
                    out_ptr[bptr] = (col0 + col1 * 2 + col2) / 12;
                    ++bptr;
                    ++x;
                }
                out_ptr[bptr] = (col1 * 2 + col2) / 9;
                ++bptr;
                return;
            }
        }
        throw new NyARException();
    }
}

