/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core.param;

import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import jp.nyatla.nyartoolkit.core.NyARException;
import jp.nyatla.nyartoolkit.core.param.NyARCameraDistortionFactor;
import jp.nyatla.nyartoolkit.core.param.NyARPerspectiveProjectionMatrix;
import jp.nyatla.nyartoolkit.core.types.NyARIntSize;
import jp.nyatla.nyartoolkit.core.types.matrix.NyARDoubleMatrix44;

public class NyARParam {
    protected NyARIntSize _screen_size = new NyARIntSize();
    private static final int SIZE_OF_PARAM_SET = 136;
    private NyARCameraDistortionFactor _dist = new NyARCameraDistortionFactor();
    private NyARPerspectiveProjectionMatrix _projection_matrix = new NyARPerspectiveProjectionMatrix();

    public void loadDefaultParameter() {
        double[] tmp = new double[]{318.5, 263.5, 26.2, 1.0127565206658486};
        this._screen_size.setValue(640, 480);
        this._dist.setValue(tmp);
        this._projection_matrix.m00 = 700.9514702992245;
        this._projection_matrix.m01 = 0.0;
        this._projection_matrix.m02 = 316.5;
        this._projection_matrix.m03 = 0.0;
        this._projection_matrix.m10 = 0.0;
        this._projection_matrix.m11 = 726.0941816535367;
        this._projection_matrix.m12 = 241.5;
        this._projection_matrix.m13 = 0.0;
        this._projection_matrix.m20 = 0.0;
        this._projection_matrix.m21 = 0.0;
        this._projection_matrix.m22 = 1.0;
        this._projection_matrix.m23 = 0.0;
        this._projection_matrix.m30 = 0.0;
        this._projection_matrix.m31 = 0.0;
        this._projection_matrix.m32 = 0.0;
        this._projection_matrix.m33 = 1.0;
    }

    public NyARIntSize getScreenSize() {
        return this._screen_size;
    }

    public NyARPerspectiveProjectionMatrix getPerspectiveProjectionMatrix() {
        return this._projection_matrix;
    }

    public NyARCameraDistortionFactor getDistortionFactor() {
        return this._dist;
    }

    public void setValue(double[] i_factor, double[] i_projection) {
        this._dist.setValue(i_factor);
        this._projection_matrix.setValue(i_projection);
    }

    public void changeScreenSize(int i_xsize, int i_ysize) {
        double scale = (double)i_xsize / (double)this._screen_size.w;
        this._dist.changeScale(scale);
        this._projection_matrix.changeScale(scale);
        this._screen_size.w = i_xsize;
        this._screen_size.h = i_ysize;
    }

    public void changeScreenSize(NyARIntSize i_s) {
        this.changeScreenSize(i_s.w, i_s.h);
    }

    public void makeCameraFrustumRH(double i_dist_min, double i_dist_max, NyARDoubleMatrix44 o_frustum) {
        this._projection_matrix.makeCameraFrustumRH(this._screen_size.w, this._screen_size.h, i_dist_min, i_dist_max, o_frustum);
    }

    public void loadARParam(InputStream i_stream) throws NyARException {
        try {
            byte[] buf = new byte[136];
            i_stream.read(buf);
            double[] tmp = new double[16];
            ByteBuffer bb = ByteBuffer.wrap(buf);
            bb.order(ByteOrder.BIG_ENDIAN);
            this._screen_size.w = bb.getInt();
            this._screen_size.h = bb.getInt();
            int i = 0;
            while (i < 12) {
                tmp[i] = bb.getDouble();
                ++i;
            }
            tmp[14] = 0.0;
            tmp[13] = 0.0;
            tmp[12] = 0.0;
            tmp[15] = 1.0;
            this._projection_matrix.setValue(tmp);
            i = 0;
            while (i < 4) {
                tmp[i] = bb.getDouble();
                ++i;
            }
            this._dist.setValue(tmp);
        }
        catch (Exception e) {
            throw new NyARException(e);
        }
    }

    public void saveARParam(OutputStream i_stream) throws Exception {
        NyARException.trap("\u672a\u30c1\u30a7\u30c3\u30af\u306e\u95a2\u6570");
        byte[] buf = new byte[136];
        ByteBuffer bb = ByteBuffer.wrap(buf);
        bb.order(ByteOrder.BIG_ENDIAN);
        bb.putInt(this._screen_size.w);
        bb.putInt(this._screen_size.h);
        double[] tmp = new double[12];
        this._projection_matrix.getValue(tmp);
        int i = 0;
        while (i < 12) {
            tmp[i] = bb.getDouble();
            ++i;
        }
        this._dist.getValue(tmp);
        i = 0;
        while (i < 4) {
            tmp[i] = bb.getDouble();
            ++i;
        }
        i_stream.write(buf);
    }
}

