/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core;

import jp.nyatla.nyartoolkit.NyARException;
import jp.nyatla.nyartoolkit.core.NyARColorPatt;
import jp.nyatla.nyartoolkit.core.NyARMarker;
import jp.nyatla.nyartoolkit.core.NyARMat;
import jp.nyatla.nyartoolkit.core.raster.NyARRaster;

public class NyARColorPatt_O3
implements NyARColorPatt {
    private static final int AR_PATT_SAMPLE_NUM = 64;
    private int[][][] extpat;
    private int width;
    private int height;
    private final NyARMat wk_get_cpara_a = new NyARMat(8, 8);
    private final NyARMat wk_get_cpara_b = new NyARMat(8, 1);
    private final double[][] wk_pickFromRaster_world = new double[][]{{100.0, 100.0}, {110.0, 100.0}, {110.0, 110.0}, {100.0, 110.0}};
    private final double[][] wk_pickFromRaster_local = new double[2][4];
    private final NyARMat wk_pickFromRaster_cpara = new NyARMat(8, 1);
    private double[] wk_updateExtpat_para00_xw;
    private double[] wk_updateExtpat_para10_xw;
    private double[] wk_updateExtpat_para20_xw;
    private int[] wk_updateExtpat_rgb_buf;
    private int[] wk_updateExtpat_x_rgb_index;
    private int[] wk_updateExtpat_y_rgb_index;
    private int[] wk_updateExtpat_i_rgb_index;
    private int wk_updateExtpat_buffer_size = 0;

    public NyARColorPatt_O3(int i_width, int i_height) {
        this.width = i_width;
        this.height = i_height;
        this.extpat = new int[i_height][i_width][3];
    }

    @Override
    public int[][][] getPatArray() {
        return this.extpat;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    private boolean get_cpara(double[] vertex_0, double[] vertex_1, NyARMat o_para) throws NyARException {
        double[][] world = this.wk_pickFromRaster_world;
        NyARMat a = this.wk_get_cpara_a;
        double[][] a_array = a.getArray();
        NyARMat b = this.wk_get_cpara_b;
        double[][] b_array = b.getArray();
        for (int i = 0; i < 4; ++i) {
            double[] a_pt0 = a_array[i * 2];
            double[] a_pt1 = a_array[i * 2 + 1];
            double[] world_pti = world[i];
            a_pt0[0] = world_pti[0];
            a_pt0[1] = world_pti[1];
            a_pt0[2] = 1.0;
            a_pt0[3] = 0.0;
            a_pt0[4] = 0.0;
            a_pt0[5] = 0.0;
            a_pt0[6] = -world_pti[0] * vertex_0[i];
            a_pt0[7] = -world_pti[1] * vertex_0[i];
            a_pt1[0] = 0.0;
            a_pt1[1] = 0.0;
            a_pt1[2] = 0.0;
            a_pt1[3] = world_pti[0];
            a_pt1[4] = world_pti[1];
            a_pt1[5] = 1.0;
            a_pt1[6] = -world_pti[0] * vertex_1[i];
            a_pt1[7] = -world_pti[1] * vertex_1[i];
            b_array[i * 2 + 0][0] = vertex_0[i];
            b_array[i * 2 + 1][0] = vertex_1[i];
        }
        if (!a.matrixSelfInv()) {
            return false;
        }
        o_para.matrixMul(a, b);
        return true;
    }

    private static void initValue_wk_pickFromRaster_ext_pat2(int[][][] i_ext_pat2, int i_width, int i_height) {
        for (int i = i_height - 1; i >= 0; --i) {
            int[][] pt2 = i_ext_pat2[i];
            for (int i2 = i_width - 1; i2 >= 0; --i2) {
                int[] pt1 = pt2[i2];
                pt1[0] = 0;
                pt1[1] = 0;
                pt1[2] = 0;
            }
        }
    }

    @Override
    public boolean pickFromRaster(NyARRaster image, NyARMarker i_marker) throws NyARException {
        NyARMat cpara = this.wk_pickFromRaster_cpara;
        int[] x_coord = i_marker.x_coord;
        int[] y_coord = i_marker.y_coord;
        int[] vertex = i_marker.mkvertex;
        double[] local_0 = this.wk_pickFromRaster_local[0];
        double[] local_1 = this.wk_pickFromRaster_local[1];
        for (int i = 0; i < 4; ++i) {
            local_0[i] = x_coord[vertex[i]];
            local_1[i] = y_coord[vertex[i]];
        }
        double w1 = local_0[0] - local_0[1];
        double w2 = local_1[0] - local_1[1];
        w1 = local_0[2] - local_0[3];
        w2 = local_1[2] - local_1[3];
        int l2 = (int)(w1 * w1 + w2 * w2);
        int l1 = (int)(w1 * w1 + w2 * w2);
        if (l2 > l1) {
            l1 = l2;
        }
        l1 /= 4;
        int xdiv2 = this.width;
        while (xdiv2 * xdiv2 < l1) {
            xdiv2 *= 2;
        }
        if (xdiv2 > 64) {
            xdiv2 = 64;
        }
        w1 = local_0[1] - local_0[2];
        w2 = local_1[1] - local_1[2];
        w1 = local_0[3] - local_0[0];
        w2 = local_1[3] - local_1[0];
        l2 = (int)(w1 * w1 + w2 * w2);
        l1 = (int)(w1 * w1 + w2 * w2);
        if (l2 > l1) {
            l1 = l2;
        }
        int ydiv2 = this.height;
        l1 /= 4;
        while (ydiv2 * ydiv2 < l1) {
            ydiv2 *= 2;
        }
        if (ydiv2 > 64) {
            ydiv2 = 64;
        }
        if (!this.get_cpara(local_0, local_1, cpara)) {
            return false;
        }
        this.updateExtpat(image, cpara, xdiv2, ydiv2);
        return true;
    }

    private void reservWorkBuffers(int i_xdiv2) {
        if (this.wk_updateExtpat_buffer_size < i_xdiv2) {
            this.wk_updateExtpat_para00_xw = new double[i_xdiv2];
            this.wk_updateExtpat_para10_xw = new double[i_xdiv2];
            this.wk_updateExtpat_para20_xw = new double[i_xdiv2];
            this.wk_updateExtpat_rgb_buf = new int[i_xdiv2 * 3];
            this.wk_updateExtpat_x_rgb_index = new int[i_xdiv2];
            this.wk_updateExtpat_y_rgb_index = new int[i_xdiv2];
            this.wk_updateExtpat_i_rgb_index = new int[i_xdiv2];
            this.wk_updateExtpat_buffer_size = i_xdiv2;
        }
    }

    private void updateExtpat(NyARRaster image, NyARMat i_cpara, int i_xdiv2, int i_ydiv2) throws NyARException {
        int[] extpat_j_i;
        int[][] extpat_j;
        int j;
        int i;
        int img_x = image.getWidth();
        int img_y = image.getHeight();
        int[][][] L_extpat = this.extpat;
        int L_WIDTH = this.width;
        int L_HEIGHT = this.height;
        NyARColorPatt_O3.initValue_wk_pickFromRaster_ext_pat2(L_extpat, L_WIDTH, L_HEIGHT);
        double[][] cpara_array = i_cpara.getArray();
        double para00 = cpara_array[0][0];
        double para01 = cpara_array[1][0];
        double para02 = cpara_array[2][0];
        double para10 = cpara_array[3][0];
        double para11 = cpara_array[4][0];
        double para12 = cpara_array[5][0];
        double para20 = cpara_array[6][0];
        double para21 = cpara_array[7][0];
        int xdiv = i_xdiv2 / L_WIDTH;
        int ydiv = i_ydiv2 / L_HEIGHT;
        this.reservWorkBuffers(i_xdiv2);
        double[] para00_xw = this.wk_updateExtpat_para00_xw;
        double[] para10_xw = this.wk_updateExtpat_para10_xw;
        double[] para20_xw = this.wk_updateExtpat_para20_xw;
        int[] x_rgb_index = this.wk_updateExtpat_x_rgb_index;
        int[] y_rgb_index = this.wk_updateExtpat_y_rgb_index;
        int[] i_rgb_index = this.wk_updateExtpat_i_rgb_index;
        int[] rgb_buf = this.wk_updateExtpat_rgb_buf;
        for (i = 0; i < i_xdiv2; ++i) {
            double xw = 102.5 + 5.0 * ((double)i + 0.5) / (double)i_xdiv2;
            para20_xw[i] = para20 * xw;
            para00_xw[i] = para00 * xw;
            para10_xw[i] = para10 * xw;
        }
        for (j = 0; j < i_ydiv2; ++j) {
            double yw = 102.5 + 5.0 * ((double)j + 0.5) / (double)i_ydiv2;
            double para21_x_yw = para21 * yw + 1.0;
            double para11_x_yw = para11 * yw + para12;
            double para01_x_yw = para01 * yw + para02;
            extpat_j = L_extpat[j / ydiv];
            int index_num = 0;
            for (i = 0; i < i_xdiv2; ++i) {
                double d = para20_xw[i] + para21_x_yw;
                if (d == 0.0) {
                    throw new NyARException();
                }
                int xc = (int)((para00_xw[i] + para01_x_yw) / d);
                int yc = (int)((para10_xw[i] + para11_x_yw) / d);
                if (xc < 0 || xc >= img_x || yc < 0 || yc >= img_y) continue;
                x_rgb_index[index_num] = xc;
                y_rgb_index[index_num] = yc;
                i_rgb_index[index_num] = i / xdiv;
                ++index_num;
            }
            image.getPixelSet(x_rgb_index, y_rgb_index, index_num, rgb_buf);
            for (i = index_num - 1; i >= 0; --i) {
                extpat_j_i = extpat_j[i_rgb_index[i]];
                extpat_j_i[0] = extpat_j_i[0] + rgb_buf[i * 3 + 0];
                extpat_j_i[1] = extpat_j_i[1] + rgb_buf[i * 3 + 1];
                extpat_j_i[2] = extpat_j_i[2] + rgb_buf[i * 3 + 2];
            }
        }
        int xdiv_x_ydiv = xdiv * ydiv;
        for (j = L_HEIGHT - 1; j >= 0; --j) {
            extpat_j = L_extpat[j];
            for (i = L_WIDTH - 1; i >= 0; --i) {
                extpat_j_i = extpat_j[i];
                extpat_j_i[0] = extpat_j_i[0] / xdiv_x_ydiv;
                extpat_j_i[1] = extpat_j_i[1] / xdiv_x_ydiv;
                extpat_j_i[2] = extpat_j_i[2] / xdiv_x_ydiv;
            }
        }
    }
}

